const mysql = require('mysql2/promise');

async function addDriverColumn() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding driver_name column to diesel_purchases table...');

    // Check if column exists
    const [columns] = await connection.execute(`
      SELECT COLUMN_NAME 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'diesel_purchases'
      AND COLUMN_NAME = 'driver_name'
    `);

    if (columns.length > 0) {
      console.log('✅ driver_name column already exists');
    } else {
      console.log('❌ driver_name column missing, adding it...');
      
      try {
        await connection.execute(`
          ALTER TABLE diesel_purchases 
          ADD COLUMN driver_name VARCHAR(255) NULL 
          AFTER vehicle_id
        `);
        console.log('✅ Successfully added driver_name column');
      } catch (error) {
        console.log('❌ Error adding column:', error.message);
        throw error;
      }
    }

    // Verify the column was added
    const [tableStructure] = await connection.execute('DESCRIBE diesel_purchases');
    console.log('\n📋 diesel_purchases table structure:');
    tableStructure.forEach(col => {
      console.log(`  - ${col.Field}: ${col.Type} ${col.Null === 'YES' ? 'NULL' : 'NOT NULL'}`);
    });

    // Test the column
    const [testQuery] = await connection.execute(`
      SELECT COUNT(*) as count FROM diesel_purchases
    `);
    console.log(`\n📊 Total diesel purchases: ${testQuery[0].count}`);

  } catch (error) {
    console.error('❌ Error:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addDriverColumn();
