const mysql = require('mysql2/promise');

async function addDriverNameColumn() {
  let connection;
  
  try {
    // Create connection
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('Connected to database');

    // Check if driver_name column exists
    const [columns] = await connection.execute(`
      SELECT COLUMN_NAME 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'diesel_purchases'
      AND COLUMN_NAME = 'driver_name'
    `);

    if (columns.length === 0) {
      // Add driver_name column
      await connection.execute(`
        ALTER TABLE diesel_purchases 
        ADD COLUMN driver_name VARCHAR(255) NULL 
        AFTER vehicle_id
      `);
      console.log('✅ Added driver_name column to diesel_purchases table');
    } else {
      console.log('✅ driver_name column already exists in diesel_purchases table');
    }

  } catch (error) {
    console.error('❌ Error adding driver_name column:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('Database connection closed');
    }
  }
}

addDriverNameColumn();
