const mysql = require('mysql2/promise');

async function addMissingColumns() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: 'root',
    database: 'cement_db'
  });

  try {
    console.log('Adding missing columns to receipts table...');
    
    // Add customer_id column
    try {
      await connection.execute('ALTER TABLE receipts ADD COLUMN customer_id INT NULL');
      console.log('✅ Added customer_id column');
    } catch (error) {
      console.log('ℹ️ customer_id column already exists');
    }
    
    // Add bunk_id column
    try {
      await connection.execute('ALTER TABLE receipts ADD COLUMN bunk_id INT NULL');
      console.log('✅ Added bunk_id column');
    } catch (error) {
      console.log('ℹ️ bunk_id column already exists');
    }
    
    // Add bank_id column
    try {
      await connection.execute('ALTER TABLE receipts ADD COLUMN bank_id INT NULL');
      console.log('✅ Added bank_id column');
    } catch (error) {
      console.log('ℹ️ bank_id column already exists');
    }
    
    // Add driver_id column
    try {
      await connection.execute('ALTER TABLE receipts ADD COLUMN driver_id INT NULL');
      console.log('✅ Added driver_id column');
    } catch (error) {
      console.log('ℹ️ driver_id column already exists');
    }
    
    // Add vehicle_no column
    try {
      await connection.execute('ALTER TABLE receipts ADD COLUMN vehicle_no VARCHAR(255) NULL');
      console.log('✅ Added vehicle_no column');
    } catch (error) {
      console.log('ℹ️ vehicle_no column already exists');
    }
    
    console.log('\n📋 Checking current receipts table structure...');
    const [columns] = await connection.execute('DESCRIBE receipts');
    console.log('Current columns in receipts table:');
    columns.forEach(col => {
      console.log(`  - ${col.Field} (${col.Type})`);
    });
    
    console.log('\n✅ All columns added successfully!');
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    await connection.end();
  }
}

addMissingColumns();
