const mysql = require('mysql2/promise');

async function addTestData() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding test data to database...\n');

    // Check if we have any data
    const [invoiceCount] = await connection.execute('SELECT COUNT(*) as count FROM invoices');
    const [paymentCount] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    const [receiptCount] = await connection.execute('SELECT COUNT(*) as count FROM receipts');
    const [driverCount] = await connection.execute('SELECT COUNT(*) as count FROM drivers');

    console.log(`📊 Current data: Invoices: ${invoiceCount[0].count}, Payments: ${paymentCount[0].count}, Receipts: ${receiptCount[0].count}, Drivers: ${driverCount[0].count}`);

    // Add a test driver if none exist
    if (driverCount[0].count === 0) {
      console.log('👤 Adding test driver...');
      await connection.execute(`
        INSERT INTO drivers (name, phone, alt_phone) 
        VALUES ('Test Driver', '1234567890', '0987654321')
      `);
      console.log('✅ Test driver added');
    }

    // Add test receipts if none exist
    if (receiptCount[0].count === 0) {
      console.log('🧾 Adding test receipts...');
      
      // Get the first driver
      const [drivers] = await connection.execute('SELECT id FROM drivers LIMIT 1');
      if (drivers.length > 0) {
        const driverId = drivers[0].id;
        
        const testReceipts = [
          {
            bill_no: 'RCP-001',
            payment_date: '2024-01-15',
            payment_amount: 1500.00,
            payment_mode: 'Cash',
            reference_number: '',
            notes: 'Test receipt 1',
            driver_id: driverId
          },
          {
            bill_no: 'RCP-002', 
            payment_date: '2024-01-20',
            payment_amount: 2500.00,
            payment_mode: 'Bank Transfer',
            reference_number: 'TXN123456',
            notes: 'Test receipt 2',
            driver_id: driverId
          }
        ];

        for (const receipt of testReceipts) {
          await connection.execute(`
            INSERT INTO receipts (
              bill_no, payment_date, payment_amount, payment_mode,
              reference_number, notes, driver_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?)
          `, [
            receipt.bill_no,
            receipt.payment_date,
            receipt.payment_amount,
            receipt.payment_mode,
            receipt.reference_number,
            receipt.notes,
            receipt.driver_id
          ]);
        }
        console.log('✅ Test receipts added');
      }
    }

    // Add test payment entries if none exist
    if (paymentCount[0].count === 0) {
      console.log('💳 Adding test payment entries...');
      
      const testPayments = [
        {
          bill_no: 'PAY-001',
          bill_date: '2024-01-15',
          amount: 5000.00,
          account_type_bank_name: 'Test Account',
          note: 'Test payment 1'
        },
        {
          bill_no: 'PAY-002',
          bill_date: '2024-01-20', 
          amount: 3000.00,
          account_type_bank_name: 'Test Account 2',
          note: 'Test payment 2'
        }
      ];

      for (const payment of testPayments) {
        await connection.execute(`
          INSERT INTO payment_entries (
            bill_no, bill_date, amount, account_type_bank_name, note
          ) VALUES (?, ?, ?, ?, ?)
        `, [
          payment.bill_no,
          payment.bill_date,
          payment.amount,
          payment.account_type_bank_name,
          payment.note
        ]);
      }
      console.log('✅ Test payment entries added');
    }

    // Add test invoices if none exist
    if (invoiceCount[0].count === 0) {
      console.log('📄 Adding test invoices...');
      
      const testInvoices = [
        {
          supplier_invoice_date: '2024-01-15',
          total: 10000.00,
          supplier_name: 'Test Supplier 1'
        },
        {
          supplier_invoice_date: '2024-01-20',
          total: 15000.00,
          supplier_name: 'Test Supplier 2'
        }
      ];

      for (const invoice of testInvoices) {
        await connection.execute(`
          INSERT INTO invoices (
            supplier_invoice_date, total, supplier_name
          ) VALUES (?, ?, ?)
        `, [
          invoice.supplier_invoice_date,
          invoice.total,
          invoice.supplier_name
        ]);
      }
      console.log('✅ Test invoices added');
    }

    // Final count
    const [finalInvoiceCount] = await connection.execute('SELECT COUNT(*) as count FROM invoices');
    const [finalPaymentCount] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    const [finalReceiptCount] = await connection.execute('SELECT COUNT(*) as count FROM receipts');
    const [finalDriverCount] = await connection.execute('SELECT COUNT(*) as count FROM drivers');

    console.log('\n📊 Final data count:');
    console.log(`  - Invoices: ${finalInvoiceCount[0].count}`);
    console.log(`  - Payment Entries: ${finalPaymentCount[0].count}`);
    console.log(`  - Receipts: ${finalReceiptCount[0].count}`);
    console.log(`  - Drivers: ${finalDriverCount[0].count}`);

    console.log('\n✅ Test data setup completed!');
    console.log('🎯 Now test the dashboard - data should appear!');

  } catch (error) {
    console.error('❌ Error adding test data:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addTestData();

async function addTestData() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding test data to database...\n');

    // Check if we have any data
    const [invoiceCount] = await connection.execute('SELECT COUNT(*) as count FROM invoices');
    const [paymentCount] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    const [receiptCount] = await connection.execute('SELECT COUNT(*) as count FROM receipts');
    const [driverCount] = await connection.execute('SELECT COUNT(*) as count FROM drivers');

    console.log(`📊 Current data: Invoices: ${invoiceCount[0].count}, Payments: ${paymentCount[0].count}, Receipts: ${receiptCount[0].count}, Drivers: ${driverCount[0].count}`);

    // Add a test driver if none exist
    if (driverCount[0].count === 0) {
      console.log('👤 Adding test driver...');
      await connection.execute(`
        INSERT INTO drivers (name, phone, alt_phone) 
        VALUES ('Test Driver', '1234567890', '0987654321')
      `);
      console.log('✅ Test driver added');
    }

    // Add test receipts if none exist
    if (receiptCount[0].count === 0) {
      console.log('🧾 Adding test receipts...');
      
      // Get the first driver
      const [drivers] = await connection.execute('SELECT id FROM drivers LIMIT 1');
      if (drivers.length > 0) {
        const driverId = drivers[0].id;
        
        const testReceipts = [
          {
            bill_no: 'RCP-001',
            payment_date: '2024-01-15',
            payment_amount: 1500.00,
            payment_mode: 'Cash',
            reference_number: '',
            notes: 'Test receipt 1',
            driver_id: driverId
          },
          {
            bill_no: 'RCP-002', 
            payment_date: '2024-01-20',
            payment_amount: 2500.00,
            payment_mode: 'Bank Transfer',
            reference_number: 'TXN123456',
            notes: 'Test receipt 2',
            driver_id: driverId
          }
        ];

        for (const receipt of testReceipts) {
          await connection.execute(`
            INSERT INTO receipts (
              bill_no, payment_date, payment_amount, payment_mode,
              reference_number, notes, driver_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?)
          `, [
            receipt.bill_no,
            receipt.payment_date,
            receipt.payment_amount,
            receipt.payment_mode,
            receipt.reference_number,
            receipt.notes,
            receipt.driver_id
          ]);
        }
        console.log('✅ Test receipts added');
      }
    }

    // Add test payment entries if none exist
    if (paymentCount[0].count === 0) {
      console.log('💳 Adding test payment entries...');
      
      const testPayments = [
        {
          bill_no: 'PAY-001',
          bill_date: '2024-01-15',
          amount: 5000.00,
          account_type_bank_name: 'Test Account',
          note: 'Test payment 1'
        },
        {
          bill_no: 'PAY-002',
          bill_date: '2024-01-20', 
          amount: 3000.00,
          account_type_bank_name: 'Test Account 2',
          note: 'Test payment 2'
        }
      ];

      for (const payment of testPayments) {
        await connection.execute(`
          INSERT INTO payment_entries (
            bill_no, bill_date, amount, account_type_bank_name, note
          ) VALUES (?, ?, ?, ?, ?)
        `, [
          payment.bill_no,
          payment.bill_date,
          payment.amount,
          payment.account_type_bank_name,
          payment.note
        ]);
      }
      console.log('✅ Test payment entries added');
    }

    // Add test invoices if none exist
    if (invoiceCount[0].count === 0) {
      console.log('📄 Adding test invoices...');
      
      const testInvoices = [
        {
          supplier_invoice_date: '2024-01-15',
          total: 10000.00,
          supplier_name: 'Test Supplier 1'
        },
        {
          supplier_invoice_date: '2024-01-20',
          total: 15000.00,
          supplier_name: 'Test Supplier 2'
        }
      ];

      for (const invoice of testInvoices) {
        await connection.execute(`
          INSERT INTO invoices (
            supplier_invoice_date, total, supplier_name
          ) VALUES (?, ?, ?)
        `, [
          invoice.supplier_invoice_date,
          invoice.total,
          invoice.supplier_name
        ]);
      }
      console.log('✅ Test invoices added');
    }

    // Final count
    const [finalInvoiceCount] = await connection.execute('SELECT COUNT(*) as count FROM invoices');
    const [finalPaymentCount] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    const [finalReceiptCount] = await connection.execute('SELECT COUNT(*) as count FROM receipts');
    const [finalDriverCount] = await connection.execute('SELECT COUNT(*) as count FROM drivers');

    console.log('\n📊 Final data count:');
    console.log(`  - Invoices: ${finalInvoiceCount[0].count}`);
    console.log(`  - Payment Entries: ${finalPaymentCount[0].count}`);
    console.log(`  - Receipts: ${finalReceiptCount[0].count}`);
    console.log(`  - Drivers: ${finalDriverCount[0].count}`);

    console.log('\n✅ Test data setup completed!');
    console.log('🎯 Now test the dashboard - data should appear!');

  } catch (error) {
    console.error('❌ Error adding test data:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addTestData();


























