const mysql = require('mysql2/promise');

async function addTestDieselData() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== ADDING TEST DIESEL DATA ===');
  
  try {
    // First, get the Diesel expense type ID
    const [dieselType] = await connection.query('SELECT id FROM expense_types WHERE name = ?', ['Diesel']);
    const dieselTypeId = dieselType.length > 0 ? dieselType[0].id : null;
    
    if (!dieselTypeId) {
      console.log('Diesel expense type not found. Creating it...');
      const [result] = await connection.query(
        'INSERT INTO expense_types (name, description, category) VALUES (?, ?, ?)',
        ['Diesel', 'Fuel expenses', 'fuel']
      );
      const newDieselTypeId = result.insertId;
      console.log('Created Diesel expense type with ID:', newDieselTypeId);
      
      // Add test payment entry
      await connection.query(
        'INSERT INTO payment_entries (bill_no, note, selected_expense_id, expense_amount, driver_name, vehicle_number, total, bill_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)',
        ['PE001', 'Diesel purchase for truck', newDieselTypeId, 2500, 'Raj Kumar', 'KA-01-AB-1234', 2500, new Date()]
      );
      
      // Add test expense
      await connection.query(
        'INSERT INTO expenses (type, amount, expense_date, driver_name, vehicle_number) VALUES (?, ?, ?, ?, ?)',
        ['diesel', 1800, new Date(), 'Suresh Kumar', 'KA-02-CD-5678']
      );
      
      console.log('✅ Added test data for Diesel expense type');
    } else {
      console.log('Diesel expense type found with ID:', dieselTypeId);
      
      // Add test payment entry
      await connection.query(
        'INSERT INTO payment_entries (bill_no, note, selected_expense_id, expense_amount, driver_name, vehicle_number, total, bill_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)',
        ['PE002', 'Diesel fuel purchase', dieselTypeId, 3000, 'Amit Singh', 'KA-03-EF-9012', 3000, new Date()]
      );
      
      // Add test expense
      await connection.query(
        'INSERT INTO expenses (type, amount, expense_date, driver_name, vehicle_number) VALUES (?, ?, ?, ?, ?)',
        ['diesel', 2200, new Date(), 'Vikram Patel', 'KA-04-GH-3456']
      );
      
      console.log('✅ Added test data for existing Diesel expense type');
    }
    
    // Verify the data was added
    console.log('\n--- Verification ---');
    const [testPayments] = await connection.query(
      'SELECT * FROM payment_entries WHERE note LIKE "%diesel%" OR selected_expense_id = ?',
      [dieselTypeId || newDieselTypeId]
    );
    console.log('Test payments:', testPayments);
    
    const [testExpenses] = await connection.query(
      'SELECT * FROM expenses WHERE type = "diesel"'
    );
    console.log('Test expenses:', testExpenses);
    
  } catch (error) {
    console.error('Error:', error.message);
  }
  
  await connection.end();
}

addTestDieselData().catch(console.error);
