const mysql = require('mysql2/promise');

async function addTestExpenses() {
  let connection;
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement'
    });

    console.log('Connected to database');

    // Add some test expenses
    const testExpenses = [
      {
        type: 'fuel',
        litre: 50,
        rate: 100,
        amount: 5000,
        expense_date: '2025-01-15',
        vehicle_id: 1,
        driver_id: 1
      },
      {
        type: 'toll',
        litre: null,
        rate: null,
        amount: 1000,
        expense_date: '2025-01-16',
        vehicle_id: 2,
        driver_id: 2
      },
      {
        type: 'driver_charge',
        litre: null,
        rate: null,
        amount: 6020,
        expense_date: '2025-01-17',
        vehicle_id: 3,
        driver_id: 3
      },
      {
        type: 'fuel',
        litre: 35,
        rate: 100,
        amount: 3500,
        expense_date: '2025-01-18',
        vehicle_id: 1,
        driver_id: 1
      },
      {
        type: 'toll',
        litre: null,
        rate: null,
        amount: 800,
        expense_date: '2025-01-19',
        vehicle_id: 2,
        driver_id: 2
      }
    ];

    for (const expense of testExpenses) {
      await connection.execute(
        'INSERT INTO expenses (type, litre, rate, amount, expense_date, vehicle_id, driver_id) VALUES (?, ?, ?, ?, ?, ?, ?)',
        [expense.type, expense.litre, expense.rate, expense.amount, expense.expense_date, expense.vehicle_id, expense.driver_id]
      );
      console.log(`Added expense: ${expense.type} - ₹${expense.amount}`);
    }

    console.log('Test expenses added successfully!');

  } catch (error) {
    console.error('Error adding test expenses:', error);
  } finally {
    if (connection) await connection.end();
  }
}

addTestExpenses();
