const mysql = require('mysql2/promise');

async function addTestPaymentEntries() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding test payment entries...\n');

    // Check if we have companies
    const [companies] = await connection.execute('SELECT id, name FROM companies LIMIT 3');
    console.log(`📋 Found ${companies.length} companies:`, companies.map(c => `${c.id}: ${c.name}`));

    if (companies.length === 0) {
      console.log('❌ No companies found. Please add companies first.');
      return;
    }

    // Check existing payment entries
    const [existingPayments] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    console.log(`📊 Current payment entries: ${existingPayments[0].count}`);

    // Add test payment entries for each company
    for (const company of companies) {
      console.log(`\n🔧 Adding test payment entries for company: ${company.name} (ID: ${company.id})`);
      
      const testPayments = [
        {
          bill_no: `PAY-${company.id}-001`,
          bill_date: '2024-01-15',
          amount: 5000.00,
          account_type_bank_name: `${company.name} Account`,
          note: `Payment for ${company.name} services`,
          driver_name: 'Test Driver'
        },
        {
          bill_no: `PAY-${company.id}-002`,
          bill_date: '2024-01-20',
          amount: 7500.00,
          account_type_bank_name: `${company.name} Bank Account`,
          note: `Monthly payment to ${company.name}`,
          driver_name: 'Test Driver 2'
        },
        {
          bill_no: `PAY-${company.id}-003`,
          bill_date: '2024-01-25',
          amount: 3000.00,
          account_type_bank_name: 'General Account',
          note: `Expense related to ${company.name}`,
          driver_name: 'Test Driver 3'
        }
      ];

      for (const payment of testPayments) {
        try {
          const [result] = await connection.execute(`
            INSERT INTO payment_entries (
              bill_no, bill_date, amount, account_type_bank_name, note, driver_name
            ) VALUES (?, ?, ?, ?, ?, ?)
          `, [
            payment.bill_no,
            payment.bill_date,
            payment.amount,
            payment.account_type_bank_name,
            payment.note,
            payment.driver_name
          ]);
          
          console.log(`  ✅ Created payment: ${payment.bill_no} (ID: ${result.insertId})`);
        } catch (error) {
          console.log(`  ❌ Error creating payment ${payment.bill_no}:`, error.message);
        }
      }
    }

    // Verify payments were created
    console.log('\n📊 Verifying created payment entries...');
    const [finalPayments] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    console.log(`📋 Final payment entries: ${finalPayments[0].count}`);

    // Test the filtering logic
    console.log('\n🔍 Testing payment filtering for each company...');
    for (const company of companies) {
      const [companyPayments] = await connection.execute(`
        SELECT id, bill_no, account_type_bank_name, note, amount
        FROM payment_entries 
        WHERE account_type_bank_name LIKE ? OR note LIKE ?
        ORDER BY bill_date DESC
      `, [`%${company.name}%`, `%${company.name}%`]);
      
      console.log(`  📊 Company ${company.name}: ${companyPayments.length} matching payments`);
      companyPayments.forEach(p => {
        console.log(`    - Payment ${p.id}: ${p.bill_no}, Account: ${p.account_type_bank_name}, Amount: ₹${p.amount}`);
      });
    }

    console.log('\n✅ Test payment entries added successfully!');
    console.log('🎯 Now test the company dashboard - payment entries should appear!');

  } catch (error) {
    console.error('❌ Error adding test payment entries:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addTestPaymentEntries();

async function addTestPaymentEntries() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding test payment entries...\n');

    // Check if we have companies
    const [companies] = await connection.execute('SELECT id, name FROM companies LIMIT 3');
    console.log(`📋 Found ${companies.length} companies:`, companies.map(c => `${c.id}: ${c.name}`));

    if (companies.length === 0) {
      console.log('❌ No companies found. Please add companies first.');
      return;
    }

    // Check existing payment entries
    const [existingPayments] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    console.log(`📊 Current payment entries: ${existingPayments[0].count}`);

    // Add test payment entries for each company
    for (const company of companies) {
      console.log(`\n🔧 Adding test payment entries for company: ${company.name} (ID: ${company.id})`);
      
      const testPayments = [
        {
          bill_no: `PAY-${company.id}-001`,
          bill_date: '2024-01-15',
          amount: 5000.00,
          account_type_bank_name: `${company.name} Account`,
          note: `Payment for ${company.name} services`,
          driver_name: 'Test Driver'
        },
        {
          bill_no: `PAY-${company.id}-002`,
          bill_date: '2024-01-20',
          amount: 7500.00,
          account_type_bank_name: `${company.name} Bank Account`,
          note: `Monthly payment to ${company.name}`,
          driver_name: 'Test Driver 2'
        },
        {
          bill_no: `PAY-${company.id}-003`,
          bill_date: '2024-01-25',
          amount: 3000.00,
          account_type_bank_name: 'General Account',
          note: `Expense related to ${company.name}`,
          driver_name: 'Test Driver 3'
        }
      ];

      for (const payment of testPayments) {
        try {
          const [result] = await connection.execute(`
            INSERT INTO payment_entries (
              bill_no, bill_date, amount, account_type_bank_name, note, driver_name
            ) VALUES (?, ?, ?, ?, ?, ?)
          `, [
            payment.bill_no,
            payment.bill_date,
            payment.amount,
            payment.account_type_bank_name,
            payment.note,
            payment.driver_name
          ]);
          
          console.log(`  ✅ Created payment: ${payment.bill_no} (ID: ${result.insertId})`);
        } catch (error) {
          console.log(`  ❌ Error creating payment ${payment.bill_no}:`, error.message);
        }
      }
    }

    // Verify payments were created
    console.log('\n📊 Verifying created payment entries...');
    const [finalPayments] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
    console.log(`📋 Final payment entries: ${finalPayments[0].count}`);

    // Test the filtering logic
    console.log('\n🔍 Testing payment filtering for each company...');
    for (const company of companies) {
      const [companyPayments] = await connection.execute(`
        SELECT id, bill_no, account_type_bank_name, note, amount
        FROM payment_entries 
        WHERE account_type_bank_name LIKE ? OR note LIKE ?
        ORDER BY bill_date DESC
      `, [`%${company.name}%`, `%${company.name}%`]);
      
      console.log(`  📊 Company ${company.name}: ${companyPayments.length} matching payments`);
      companyPayments.forEach(p => {
        console.log(`    - Payment ${p.id}: ${p.bill_no}, Account: ${p.account_type_bank_name}, Amount: ₹${p.amount}`);
      });
    }

    console.log('\n✅ Test payment entries added successfully!');
    console.log('🎯 Now test the company dashboard - payment entries should appear!');

  } catch (error) {
    console.error('❌ Error adding test payment entries:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addTestPaymentEntries();


























