const mysql = require('mysql2/promise');

async function addTestReceipts() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding test receipts with driver_id...\n');

    // Check if we have drivers
    const [drivers] = await connection.execute('SELECT id, name FROM drivers LIMIT 3');
    console.log(`📋 Found ${drivers.length} drivers:`, drivers.map(d => `${d.id}: ${d.name}`));

    if (drivers.length === 0) {
      console.log('❌ No drivers found. Please add drivers first.');
      return;
    }

    // Check existing receipts
    const [existingReceipts] = await connection.execute(`
      SELECT COUNT(*) as count, 
             COUNT(CASE WHEN driver_id IS NOT NULL THEN 1 END) as with_driver_id
      FROM receipts
    `);
    
    console.log(`📊 Current receipts: ${existingReceipts[0].count} total, ${existingReceipts[0].with_driver_id} with driver_id`);

    // Add test receipts for each driver
    for (const driver of drivers) {
      console.log(`\n🔧 Adding test receipts for driver: ${driver.name} (ID: ${driver.id})`);
      
      const testReceipts = [
        {
          bill_no: `RCP-${driver.id}-001`,
          payment_date: '2024-01-15',
          payment_amount: 1500.00,
          payment_mode: 'Cash',
          reference_number: '',
          notes: `Test receipt 1 for ${driver.name}`,
          driver_id: driver.id
        },
        {
          bill_no: `RCP-${driver.id}-002`,
          payment_date: '2024-01-20',
          payment_amount: 2500.00,
          payment_mode: 'Bank Transfer',
          reference_number: `TXN${driver.id}001`,
          notes: `Bank transfer receipt for ${driver.name}`,
          driver_id: driver.id
        },
        {
          bill_no: `RCP-${driver.id}-003`,
          payment_date: '2024-01-25',
          payment_amount: 3000.00,
          payment_mode: 'UPI',
          reference_number: `UPI${driver.id}001`,
          notes: `UPI receipt for ${driver.name}`,
          driver_id: driver.id
        }
      ];

      for (const receipt of testReceipts) {
        try {
          const [result] = await connection.execute(`
            INSERT INTO receipts (
              bill_no, payment_date, payment_amount, payment_mode,
              reference_number, notes, driver_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?)
          `, [
            receipt.bill_no,
            receipt.payment_date,
            receipt.payment_amount,
            receipt.payment_mode,
            receipt.reference_number,
            receipt.notes,
            receipt.driver_id
          ]);
          
          console.log(`  ✅ Created receipt: ${receipt.bill_no} (ID: ${result.insertId})`);
        } catch (error) {
          console.log(`  ❌ Error creating receipt ${receipt.bill_no}:`, error.message);
        }
      }
    }

    // Verify receipts were created
    console.log('\n📊 Verifying created receipts...');
    const [finalReceipts] = await connection.execute(`
      SELECT COUNT(*) as count, 
             COUNT(CASE WHEN driver_id IS NOT NULL THEN 1 END) as with_driver_id
      FROM receipts
    `);
    
    console.log(`📋 Final receipts: ${finalReceipts[0].count} total, ${finalReceipts[0].with_driver_id} with driver_id`);

    // Test the API query for each driver
    console.log('\n🔍 Testing API queries for each driver...');
    for (const driver of drivers) {
      const [driverReceipts] = await connection.execute(`
        SELECT id, driver_id, bill_no, payment_amount, payment_date
        FROM receipts 
        WHERE driver_id = ?
        ORDER BY payment_date DESC
      `, [driver.id]);
      
      console.log(`  📊 Driver ${driver.name} (ID: ${driver.id}): ${driverReceipts.length} receipts`);
      driverReceipts.forEach(r => {
        console.log(`    - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date}`);
      });
    }

    console.log('\n✅ Test receipts added successfully!');
    console.log('🎯 Now test the driver dashboard - receipts should appear!');

  } catch (error) {
    console.error('❌ Error adding test receipts:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addTestReceipts();

async function addTestReceipts() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Adding test receipts with driver_id...\n');

    // Check if we have drivers
    const [drivers] = await connection.execute('SELECT id, name FROM drivers LIMIT 3');
    console.log(`📋 Found ${drivers.length} drivers:`, drivers.map(d => `${d.id}: ${d.name}`));

    if (drivers.length === 0) {
      console.log('❌ No drivers found. Please add drivers first.');
      return;
    }

    // Check existing receipts
    const [existingReceipts] = await connection.execute(`
      SELECT COUNT(*) as count, 
             COUNT(CASE WHEN driver_id IS NOT NULL THEN 1 END) as with_driver_id
      FROM receipts
    `);
    
    console.log(`📊 Current receipts: ${existingReceipts[0].count} total, ${existingReceipts[0].with_driver_id} with driver_id`);

    // Add test receipts for each driver
    for (const driver of drivers) {
      console.log(`\n🔧 Adding test receipts for driver: ${driver.name} (ID: ${driver.id})`);
      
      const testReceipts = [
        {
          bill_no: `RCP-${driver.id}-001`,
          payment_date: '2024-01-15',
          payment_amount: 1500.00,
          payment_mode: 'Cash',
          reference_number: '',
          notes: `Test receipt 1 for ${driver.name}`,
          driver_id: driver.id
        },
        {
          bill_no: `RCP-${driver.id}-002`,
          payment_date: '2024-01-20',
          payment_amount: 2500.00,
          payment_mode: 'Bank Transfer',
          reference_number: `TXN${driver.id}001`,
          notes: `Bank transfer receipt for ${driver.name}`,
          driver_id: driver.id
        },
        {
          bill_no: `RCP-${driver.id}-003`,
          payment_date: '2024-01-25',
          payment_amount: 3000.00,
          payment_mode: 'UPI',
          reference_number: `UPI${driver.id}001`,
          notes: `UPI receipt for ${driver.name}`,
          driver_id: driver.id
        }
      ];

      for (const receipt of testReceipts) {
        try {
          const [result] = await connection.execute(`
            INSERT INTO receipts (
              bill_no, payment_date, payment_amount, payment_mode,
              reference_number, notes, driver_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?)
          `, [
            receipt.bill_no,
            receipt.payment_date,
            receipt.payment_amount,
            receipt.payment_mode,
            receipt.reference_number,
            receipt.notes,
            receipt.driver_id
          ]);
          
          console.log(`  ✅ Created receipt: ${receipt.bill_no} (ID: ${result.insertId})`);
        } catch (error) {
          console.log(`  ❌ Error creating receipt ${receipt.bill_no}:`, error.message);
        }
      }
    }

    // Verify receipts were created
    console.log('\n📊 Verifying created receipts...');
    const [finalReceipts] = await connection.execute(`
      SELECT COUNT(*) as count, 
             COUNT(CASE WHEN driver_id IS NOT NULL THEN 1 END) as with_driver_id
      FROM receipts
    `);
    
    console.log(`📋 Final receipts: ${finalReceipts[0].count} total, ${finalReceipts[0].with_driver_id} with driver_id`);

    // Test the API query for each driver
    console.log('\n🔍 Testing API queries for each driver...');
    for (const driver of drivers) {
      const [driverReceipts] = await connection.execute(`
        SELECT id, driver_id, bill_no, payment_amount, payment_date
        FROM receipts 
        WHERE driver_id = ?
        ORDER BY payment_date DESC
      `, [driver.id]);
      
      console.log(`  📊 Driver ${driver.name} (ID: ${driver.id}): ${driverReceipts.length} receipts`);
      driverReceipts.forEach(r => {
        console.log(`    - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date}`);
      });
    }

    console.log('\n✅ Test receipts added successfully!');
    console.log('🎯 Now test the driver dashboard - receipts should appear!');

  } catch (error) {
    console.error('❌ Error adding test receipts:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

addTestReceipts();


























