const mysql = require('mysql2/promise');

// Database configuration - update these values
const dbConfig = {
  host: 'localhost',
  user: 'root',
  password: '', // Update with your password
  database: 'cement' // Update with your database name
};

async function checkCustomerCompanyRelationships() {
  let connection;
  
  try {
    console.log('Connecting to database...');
    connection = await mysql.createConnection(dbConfig);
    console.log('Connected successfully!');

    console.log('\n=== Checking Customer-Company Relationships ===');
    
    // Check all customers
    const [customers] = await connection.execute('SELECT * FROM customers');
    console.log(`\nTotal customers: ${customers.length}`);
    customers.forEach(c => {
      console.log(`- Customer ID: ${c.id}, Name: ${c.name}, Contact: ${c.contact}`);
    });
    
    // Check all companies
    const [companies] = await connection.execute('SELECT * FROM companies');
    console.log(`\nTotal companies: ${companies.length}`);
    companies.forEach(c => {
      console.log(`- Company ID: ${c.id}, Name: ${c.name}`);
    });
    
    // Check invoices and their relationships
    const [invoices] = await connection.execute(`
      SELECT i.id, i.supplier_invoice_number, i.company_id, i.customer_id,
             c.name as company_name, cust.name as customer_name
      FROM invoices i
      LEFT JOIN companies c ON i.company_id = c.id
      LEFT JOIN customers cust ON i.customer_id = cust.id
      ORDER BY i.id
    `);
    
    console.log(`\nTotal invoices: ${invoices.length}`);
    if (invoices.length > 0) {
      invoices.forEach(inv => {
        console.log(`- Invoice ID: ${inv.id}, Number: ${inv.supplier_invoice_number}, Company: ${inv.company_name || 'N/A'} (ID: ${inv.company_id}), Customer: ${inv.customer_name || 'N/A'} (ID: ${inv.customer_id})`);
      });
    } else {
      console.log('No invoices found in the database');
    }
    
    // Check payment entries and their relationships
    const [payments] = await connection.execute(`
      SELECT pe.id, pe.bill_no, pe.company_id, pe.customer_id,
             c.name as company_name, cust.name as customer_name
      FROM payment_entries pe
      LEFT JOIN companies c ON pe.company_id = c.id
      LEFT JOIN customers cust ON pe.customer_id = cust.id
      ORDER BY pe.id
    `);
    
    console.log(`\nTotal payment entries: ${payments.length}`);
    payments.forEach(p => {
      console.log(`- Payment ID: ${p.id}, Bill: ${p.bill_no}, Company: ${p.company_name || 'N/A'} (ID: ${p.company_id}), Customer: ${p.customer_name || 'N/A'} (ID: ${p.customer_id})`);
    });

  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed.');
    }
  }
}

// Run the script
checkCustomerCompanyRelationships();
