const mysql = require('mysql2/promise');

async function checkDieselBunks() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== Diesel Purchases with Bunk Info ===');
  const [dieselPurchases] = await connection.query(`
    SELECT dp.id, dp.bill_no, dp.bunk_id, b.bunk_name, dp.litres, dp.rate, dp.total_amount
    FROM diesel_purchases dp 
    LEFT JOIN bunks b ON dp.bunk_id = b.id
    ORDER BY dp.created_at DESC
    LIMIT 10
  `);
  
  dieselPurchases.forEach(p => {
    console.log(`ID: ${p.id}, Bill: ${p.bill_no}, Bunk ID: ${p.bunk_id}, Bunk Name: ${p.bunk_name || 'NULL'}`);
  });
  
  console.log('\n=== Available Bunks ===');
  const [bunks] = await connection.query('SELECT id, bunk_name FROM bunks');
  bunks.forEach(b => {
    console.log(`Bunk ID: ${b.id}, Bunk Name: ${b.bunk_name}`);
  });
  
  await connection.end();
}

checkDieselBunks().catch(console.error);
