const mysql = require('mysql2/promise');

async function checkExpenseData() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== CHECKING EXPENSE DATA ===');
  
  try {
    // Check expense types
    console.log('\n--- Expense Types ---');
    const [expenseTypes] = await connection.query('SELECT * FROM expense_types');
    console.log('Expense Types:', expenseTypes);
    
    // Check expenses
    console.log('\n--- Expenses ---');
    const [expenses] = await connection.query('SELECT * FROM expenses LIMIT 5');
    console.log('Expenses:', expenses);
    
    // Check payment entries
    console.log('\n--- Payment Entries ---');
    const [payments] = await connection.query('SELECT id, bill_no, note, selected_expense_id, expense_amount, driver_name, vehicle_number FROM payment_entries LIMIT 5');
    console.log('Payment Entries:', payments);
    
    // Check receipts
    console.log('\n--- Receipts ---');
    const [receipts] = await connection.query('SELECT * FROM receipts LIMIT 5');
    console.log('Receipts:', receipts);
    
    // Check invoices
    console.log('\n--- Invoices ---');
    const [invoices] = await connection.query('SELECT * FROM invoices LIMIT 5');
    console.log('Invoices:', invoices);
    
  } catch (error) {
    console.error('Error:', error.message);
  }
  
  await connection.end();
}

checkExpenseData().catch(console.error);
