const mysql = require('mysql2/promise');

async function checkExpenseTypes() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== CHECKING EXPENSE TYPES ===');
  
  try {
    // Check all expense types
    const [expenseTypes] = await connection.query('SELECT * FROM expense_types');
    console.log('All expense types:', expenseTypes);
    
    // Check if Diesel exists
    const [dieselTypes] = await connection.query('SELECT * FROM expense_types WHERE name = ?', ['Diesel']);
    console.log('Diesel expense types:', dieselTypes);
    
    // If no Diesel, create one
    if (dieselTypes.length === 0) {
      console.log('Creating Diesel expense type...');
      const [result] = await connection.query(
        'INSERT INTO expense_types (name, description, category) VALUES (?, ?, ?)',
        ['Diesel', 'Fuel expenses', 'fuel']
      );
      console.log('Created Diesel expense type with ID:', result.insertId);
    }
    
  } catch (error) {
    console.error('Error:', error.message);
  }
  
  await connection.end();
}

checkExpenseTypes().catch(console.error);
