const mysql = require('mysql2/promise');

async function checkPaymentEntriesData() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== CHECKING PAYMENT ENTRIES DATA ===');
  
  try {
    // Check recent payment entries
    console.log('\n--- Recent Payment Entries (Last 10) ---');
    const [recentPayments] = await connection.query(`
      SELECT 
        id,
        bill_no,
        bill_date,
        account_type_bank_name,
        driver_name,
        vehicle_no,
        selected_expense_id,
        expense_amount,
        total,
        note,
        created_at
      FROM payment_entries 
      ORDER BY created_at DESC 
      LIMIT 10
    `);
    
    console.log('Recent Payment Entries:');
    recentPayments.forEach((payment, index) => {
      console.log(`\n${index + 1}. Payment ID: ${payment.id}`);
      console.log(`   Bill No: ${payment.bill_no}`);
      console.log(`   Date: ${payment.bill_date}`);
      console.log(`   Account Type: ${payment.account_type_bank_name}`);
      console.log(`   Driver: ${payment.driver_name}`);
      console.log(`   Vehicle: ${payment.vehicle_no}`);
      console.log(`   Selected Expense ID: ${payment.selected_expense_id}`);
      console.log(`   Expense Amount: ${payment.expense_amount}`);
      console.log(`   Total: ${payment.total}`);
      console.log(`   Note: ${payment.note}`);
      console.log(`   Created: ${payment.created_at}`);
    });
    
    // Check expense types that exist
    console.log('\n--- Available Expense Types ---');
    const [expenseTypes] = await connection.query('SELECT * FROM expense_types ORDER BY id');
    console.log('Expense Types:', expenseTypes);
    
    // Check expenses that exist
    console.log('\n--- Available Expenses ---');
    const [expenses] = await connection.query('SELECT * FROM expenses ORDER BY id LIMIT 5');
    console.log('Expenses (first 5):', expenses);
    
    // Check if there are any payment entries with selected_expense_id
    console.log('\n--- Payment Entries with Expense IDs ---');
    const [paymentsWithExpenseId] = await connection.query(`
      SELECT 
        id,
        bill_no,
        selected_expense_id,
        expense_amount,
        note
      FROM payment_entries 
      WHERE selected_expense_id IS NOT NULL
      ORDER BY created_at DESC
    `);
    
    console.log(`Found ${paymentsWithExpenseId.length} payment entries with expense IDs:`);
    paymentsWithExpenseId.forEach((payment, index) => {
      console.log(`${index + 1}. Payment ID: ${payment.id}, Bill: ${payment.bill_no}, Expense ID: ${payment.selected_expense_id}, Amount: ${payment.expense_amount}, Note: ${payment.note}`);
    });
    
    // Check for any recent payment entries that might have failed to save expense_id
    console.log('\n--- Recent Payment Entries with NULL Expense IDs ---');
    const [paymentsWithNullExpenseId] = await connection.query(`
      SELECT 
        id,
        bill_no,
        note,
        created_at
      FROM payment_entries 
      WHERE selected_expense_id IS NULL
      AND note IS NOT NULL
      AND note != ''
      ORDER BY created_at DESC
      LIMIT 5
    `);
    
    console.log(`Found ${paymentsWithNullExpenseId.length} recent payment entries with NULL expense IDs but with notes:`);
    paymentsWithNullExpenseId.forEach((payment, index) => {
      console.log(`${index + 1}. Payment ID: ${payment.id}, Bill: ${payment.bill_no}, Note: ${payment.note}, Created: ${payment.created_at}`);
    });
    
  } catch (error) {
    console.error('Error:', error.message);
  }
  
  await connection.end();
}

checkPaymentEntriesData().catch(console.error);










