const mysql = require('mysql2/promise');

async function checkPaymentEntriesStructure() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔍 Checking payment_entries table structure...\n');

    // Check table structure
    const [columns] = await connection.execute(`
      SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'payment_entries'
      ORDER BY ORDINAL_POSITION
    `);
    
    console.log('📋 Payment Entries Table Structure:');
    columns.forEach(col => {
      console.log(`  - ${col.COLUMN_NAME}: ${col.DATA_TYPE} (${col.IS_NULLABLE === 'YES' ? 'NULL' : 'NOT NULL'})`);
    });

    // Check if company_id exists
    const hasCompanyId = columns.some(col => col.COLUMN_NAME === 'company_id');
    console.log(`\n🏢 Has company_id column: ${hasCompanyId}`);

    // Check sample data
    const [sampleData] = await connection.execute(`
      SELECT id, account_type_bank_name, note, bill_date, amount
      FROM payment_entries 
      LIMIT 5
    `);
    
    console.log('\n📊 Sample Payment Entries:');
    sampleData.forEach(payment => {
      console.log(`  - ID: ${payment.id}, Account: ${payment.account_type_bank_name}, Note: ${payment.note}, Amount: ₹${payment.amount}`);
    });

    // Check companies
    const [companies] = await connection.execute('SELECT id, name FROM companies LIMIT 5');
    console.log('\n🏢 Sample Companies:');
    companies.forEach(company => {
      console.log(`  - ID: ${company.id}, Name: ${company.name}`);
    });

    // If no company_id column, suggest adding it
    if (!hasCompanyId) {
      console.log('\n💡 Suggestion: Add company_id column to payment_entries table');
      console.log('   ALTER TABLE payment_entries ADD COLUMN company_id INT NULL;');
      console.log('   ALTER TABLE payment_entries ADD FOREIGN KEY (company_id) REFERENCES companies(id);');
    }

  } catch (error) {
    console.error('❌ Error checking payment entries:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

checkPaymentEntriesStructure();
async function checkPaymentEntriesStructure() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔍 Checking payment_entries table structure...\n');

    // Check table structure
    const [columns] = await connection.execute(`
      SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'payment_entries'
      ORDER BY ORDINAL_POSITION
    `);
    
    console.log('📋 Payment Entries Table Structure:');
    columns.forEach(col => {
      console.log(`  - ${col.COLUMN_NAME}: ${col.DATA_TYPE} (${col.IS_NULLABLE === 'YES' ? 'NULL' : 'NOT NULL'})`);
    });

    // Check if company_id exists
    const hasCompanyId = columns.some(col => col.COLUMN_NAME === 'company_id');
    console.log(`\n🏢 Has company_id column: ${hasCompanyId}`);

    // Check sample data
    const [sampleData] = await connection.execute(`
      SELECT id, account_type_bank_name, note, bill_date, amount
      FROM payment_entries 
      LIMIT 5
    `);
    
    console.log('\n📊 Sample Payment Entries:');
    sampleData.forEach(payment => {
      console.log(`  - ID: ${payment.id}, Account: ${payment.account_type_bank_name}, Note: ${payment.note}, Amount: ₹${payment.amount}`);
    });

    // Check companies
    const [companies] = await connection.execute('SELECT id, name FROM companies LIMIT 5');
    console.log('\n🏢 Sample Companies:');
    companies.forEach(company => {
      console.log(`  - ID: ${company.id}, Name: ${company.name}`);
    });

    // If no company_id column, suggest adding it
    if (!hasCompanyId) {
      console.log('\n💡 Suggestion: Add company_id column to payment_entries table');
      console.log('   ALTER TABLE payment_entries ADD COLUMN company_id INT NULL;');
      console.log('   ALTER TABLE payment_entries ADD FOREIGN KEY (company_id) REFERENCES companies(id);');
    }

  } catch (error) {
    console.error('❌ Error checking payment entries:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

checkPaymentEntriesStructure();