const mysql = require('mysql2/promise');

async function checkPaymentTableStructure() {
  try {
    // Create database connection
    const connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_db'
    });

    console.log('🔍 Checking payment_entries table structure...');

    // Get all columns in payment_entries table
    const [columns] = await connection.query(`
      SELECT 
        COLUMN_NAME, 
        DATA_TYPE, 
        IS_NULLABLE, 
        COLUMN_DEFAULT,
        COLUMN_COMMENT
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'payment_entries'
      ORDER BY ORDINAL_POSITION
    `);
    
    console.log('📊 Payment_entries table columns:');
    columns.forEach(col => {
      console.log(`- ${col.COLUMN_NAME}: ${col.DATA_TYPE} (${col.IS_NULLABLE === 'YES' ? 'NULL' : 'NOT NULL'})`);
    });

    // Check if company_id column exists
    const companyIdExists = columns.some(col => col.COLUMN_NAME === 'company_id');
    console.log(`\n🔍 Company ID column exists: ${companyIdExists}`);

    // Check if company_name column exists
    const companyNameExists = columns.some(col => col.COLUMN_NAME === 'company_name');
    console.log(`🔍 Company name column exists: ${companyNameExists}`);

    // Get sample data to see what's actually in the table
    const [sampleData] = await connection.query(`
      SELECT * FROM payment_entries LIMIT 3
    `);
    
    console.log('\n📊 Sample payment entries:');
    if (sampleData.length > 0) {
      console.log('Available fields:', Object.keys(sampleData[0]));
      sampleData.forEach((row, index) => {
        console.log(`\nPayment ${index + 1}:`);
        Object.entries(row).forEach(([key, value]) => {
          console.log(`  ${key}: ${value}`);
        });
      });
    } else {
      console.log('No payment entries found in table');
    }

    await connection.end();
    console.log('\n✅ Check completed');
  } catch (error) {
    console.error('❌ Error:', error);
  }
}

checkPaymentTableStructure();

