const mysql = require('mysql2/promise');

async function checkReceiptsData() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });

  try {
    console.log('=== CHECKING RECEIPTS DATA ===\n');
    
    // Check receipts table structure
    const [columns] = await connection.query('DESCRIBE receipts');
    console.log('Receipts table columns:');
    columns.forEach(col => console.log(`- ${col.Field} (${col.Type})`));
    
    // Check total receipts count
    const [countResult] = await connection.query('SELECT COUNT(*) as total FROM receipts');
    console.log(`\nTotal receipts in database: ${countResult[0].total}`);
    
    // Check receipts with vehicle_no
    const [vehicleCount] = await connection.query('SELECT COUNT(*) as total FROM receipts WHERE vehicle_no IS NOT NULL AND vehicle_no != ""');
    console.log(`Receipts with vehicle_no: ${vehicleCount[0].total}`);
    
    // Check receipts with driver_id
    const [driverCount] = await connection.query('SELECT COUNT(*) as total FROM receipts WHERE driver_id IS NOT NULL');
    console.log(`Receipts with driver_id: ${driverCount[0].total}`);
    
    // Show sample receipts data
    const [receipts] = await connection.query(`
      SELECT id, vehicle_no, driver_id, bill_no, payment_date, payment_amount, payment_mode, notes, customer_id
      FROM receipts 
      ORDER BY id DESC 
      LIMIT 10
    `);
    
    console.log('\n=== SAMPLE RECEIPTS DATA ===');
    if (receipts.length > 0) {
      receipts.forEach((receipt, index) => {
        console.log(`\nReceipt ${index + 1}:`);
        console.log(`  ID: ${receipt.id}`);
        console.log(`  Vehicle No: "${receipt.vehicle_no || 'NULL'}"`);
        console.log(`  Driver ID: ${receipt.driver_id || 'NULL'}`);
        console.log(`  Bill No: "${receipt.bill_no || 'NULL'}"`);
        console.log(`  Payment Date: ${receipt.payment_date}`);
        console.log(`  Amount: ${receipt.payment_amount}`);
        console.log(`  Mode: ${receipt.payment_mode}`);
        console.log(`  Notes: "${receipt.notes || 'NULL'}"`);
        console.log(`  Customer ID: ${receipt.customer_id || 'NULL'}`);
      });
    } else {
      console.log('No receipts found in database');
    }
    
    // Check available vehicles
    const [vehicles] = await connection.query('SELECT id, number, name FROM vehicles LIMIT 10');
    console.log('\n=== AVAILABLE VEHICLES ===');
    if (vehicles.length > 0) {
      vehicles.forEach(vehicle => {
        console.log(`- ID: ${vehicle.id}, Number: "${vehicle.number}", Name: "${vehicle.name || 'N/A'}"`);
      });
    } else {
      console.log('No vehicles found in database');
    }
    
    // Check if any receipts match any vehicles
    const [matchingReceipts] = await connection.query(`
      SELECT r.id, r.vehicle_no, r.payment_amount, v.number as vehicle_number, v.name as vehicle_name
      FROM receipts r
      LEFT JOIN vehicles v ON r.vehicle_no = v.number
      WHERE r.vehicle_no IS NOT NULL AND r.vehicle_no != ""
      LIMIT 5
    `);
    
    console.log('\n=== RECEIPTS MATCHING VEHICLES ===');
    if (matchingReceipts.length > 0) {
      matchingReceipts.forEach(receipt => {
        console.log(`Receipt ID: ${receipt.id}, Vehicle No: "${receipt.vehicle_no}", Amount: ${receipt.payment_amount}`);
        console.log(`  -> Matches Vehicle: "${receipt.vehicle_number}" (${receipt.vehicle_name || 'N/A'})`);
      });
    } else {
      console.log('No receipts found that match any vehicle numbers');
    }
    
  } catch (error) {
    console.error('Error:', error.message);
  } finally {
    await connection.end();
  }
}

checkReceiptsData();