const mysql = require('mysql2/promise');

async function checkSchema() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== CHECKING DATABASE SCHEMA ===');
  
  try {
    // Check payment_entries table structure
    console.log('\n--- Payment Entries Table Structure ---');
    const [paymentEntriesColumns] = await connection.query(`
      SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = 'cement' 
      AND TABLE_NAME = 'payment_entries'
      ORDER BY ORDINAL_POSITION
    `);
    console.log('Payment Entries Columns:', paymentEntriesColumns);
    
    // Check foreign key constraints on payment_entries
    console.log('\n--- Payment Entries Foreign Keys ---');
    const [paymentEntriesFK] = await connection.query(`
      SELECT 
        CONSTRAINT_NAME,
        COLUMN_NAME,
        REFERENCED_TABLE_NAME,
        REFERENCED_COLUMN_NAME,
        DELETE_RULE,
        UPDATE_RULE
      FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
      WHERE TABLE_SCHEMA = 'cement' 
      AND TABLE_NAME = 'payment_entries'
      AND REFERENCED_TABLE_NAME IS NOT NULL
    `);
    console.log('Payment Entries Foreign Keys:', paymentEntriesFK);
    
    // Check expense_types table structure
    console.log('\n--- Expense Types Table Structure ---');
    const [expenseTypesColumns] = await connection.query(`
      SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = 'cement' 
      AND TABLE_NAME = 'expense_types'
      ORDER BY ORDINAL_POSITION
    `);
    console.log('Expense Types Columns:', expenseTypesColumns);
    
    // Check expenses table structure
    console.log('\n--- Expenses Table Structure ---');
    const [expensesColumns] = await connection.query(`
      SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = 'cement' 
      AND TABLE_NAME = 'expenses'
      ORDER BY ORDINAL_POSITION
    `);
    console.log('Expenses Columns:', expensesColumns);
    
    // Check if expense_types has data
    console.log('\n--- Expense Types Data ---');
    const [expenseTypesData] = await connection.query('SELECT * FROM expense_types');
    console.log('Expense Types:', expenseTypesData);
    
  } catch (error) {
    console.error('Error:', error.message);
  }
  
  await connection.end();
}

checkSchema().catch(console.error);

