const mysql = require('mysql2/promise');

async function createTestReceipts() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Creating test receipts with driver_id...');

    // Get all drivers
    const [drivers] = await connection.execute('SELECT id, name FROM drivers ORDER BY id');
    console.log('\n📋 Found drivers:');
    drivers.forEach(d => console.log(`  - ID: ${d.id}, Name: "${d.name}"`));

    if (drivers.length === 0) {
      console.log('❌ No drivers found. Creating a test driver first...');
      
      // Create a test driver
      const [driverResult] = await connection.execute(`
        INSERT INTO drivers (name, phone, alt_phone) VALUES (?, ?, ?)
      `, ['Test Driver', '1234567890', '0987654321']);
      
      console.log('✅ Test driver created with ID:', driverResult.insertId);
      drivers.push({ id: driverResult.insertId, name: 'Test Driver' });
    }

    // Create test receipts for each driver
    for (const driver of drivers) {
      console.log(`\n🔧 Creating test receipts for driver: ${driver.name} (ID: ${driver.id})`);
      
      // Create 2-3 test receipts for each driver
      const testReceipts = [
        {
          bill_no: `RCP-${driver.id}-001`,
          payment_date: '2024-01-15',
          payment_amount: 1500.00,
          payment_mode: 'Cash',
          reference_number: '',
          notes: `Test receipt for ${driver.name}`,
          company_id: null,
          customer_id: null,
          driver_id: driver.id,
          bank_id: null,
          bunk_id: null
        },
        {
          bill_no: `RCP-${driver.id}-002`,
          payment_date: '2024-01-20',
          payment_amount: 2500.00,
          payment_mode: 'Bank Transfer',
          reference_number: 'TXN123456',
          notes: `Bank transfer receipt for ${driver.name}`,
          company_id: null,
          customer_id: null,
          driver_id: driver.id,
          bank_id: null,
          bunk_id: null
        },
        {
          bill_no: `RCP-${driver.id}-003`,
          payment_date: '2024-01-25',
          payment_amount: 3000.00,
          payment_mode: 'Cash',
          reference_number: '',
          notes: `Another receipt for ${driver.name}`,
          company_id: null,
          customer_id: null,
          driver_id: driver.id,
          bank_id: null,
          bunk_id: null
        }
      ];

      for (const receipt of testReceipts) {
        try {
          const [result] = await connection.execute(`
            INSERT INTO receipts (
              bill_no, payment_date, payment_amount, payment_mode, 
              reference_number, notes, company_id, customer_id, 
              driver_id, bank_id, bunk_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
          `, [
            receipt.bill_no,
            receipt.payment_date,
            receipt.payment_amount,
            receipt.payment_mode,
            receipt.reference_number,
            receipt.notes,
            receipt.company_id,
            receipt.customer_id,
            receipt.driver_id,
            receipt.bank_id,
            receipt.bunk_id
          ]);
          
          console.log(`  ✅ Created receipt: ${receipt.bill_no} (ID: ${result.insertId})`);
        } catch (error) {
          console.log(`  ❌ Error creating receipt ${receipt.bill_no}:`, error.message);
        }
      }
    }

    // Verify receipts were created
    console.log('\n📊 Verifying created receipts...');
    const [allReceipts] = await connection.execute(`
      SELECT id, driver_id, bill_no, payment_amount, payment_date, created_at
      FROM receipts 
      WHERE driver_id IS NOT NULL
      ORDER BY created_at DESC
    `);
    
    console.log(`📋 Total receipts with driver_id: ${allReceipts.length}`);
    allReceipts.forEach(r => console.log(`  - Receipt ${r.id}: Driver ID: ${r.driver_id}, Bill: ${r.bill_no}, Amount: ₹${r.payment_amount}`));

    // Test the backend route query for each driver
    for (const driver of drivers) {
      console.log(`\n🔍 Testing backend route for driver: ${driver.name} (ID: ${driver.id})`);
      
      const [driverReceipts] = await connection.execute(`
        SELECT DISTINCT
          r.id,
          r.company_id,
          r.driver_id,
          r.bill_no,
          DATE_FORMAT(r.payment_date, '%Y-%m-%d') as payment_date_formatted,
          r.payment_amount,
          r.payment_mode,
          r.reference_number,
          r.notes,
          r.bank_id,
          r.created_at,
          c.name as company_name,
          b.bank_name,
          b.account_number,
          b.ifsc_code,
          b.branch,
          b.account_name as bank_account_name,
          'receipt' as transaction_type
        FROM receipts r
        LEFT JOIN companies c ON r.company_id = c.id
        LEFT JOIN banks b ON r.bank_id = b.id
        WHERE r.driver_id = ?
        ORDER BY r.payment_date DESC, r.created_at DESC
      `, [driver.id]);
      
      console.log(`  📊 Receipts found for ${driver.name}: ${driverReceipts.length}`);
      driverReceipts.forEach(r => console.log(`    - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date_formatted}`));
    }

    console.log('\n✅ Test receipts creation completed!');
    console.log('🎯 Now test the driver dashboard - receipts should appear!');

  } catch (error) {
    console.error('❌ Error creating test receipts:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

createTestReceipts();


async function createTestReceipts() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔧 Creating test receipts with driver_id...');

    // Get all drivers
    const [drivers] = await connection.execute('SELECT id, name FROM drivers ORDER BY id');
    console.log('\n📋 Found drivers:');
    drivers.forEach(d => console.log(`  - ID: ${d.id}, Name: "${d.name}"`));

    if (drivers.length === 0) {
      console.log('❌ No drivers found. Creating a test driver first...');
      
      // Create a test driver
      const [driverResult] = await connection.execute(`
        INSERT INTO drivers (name, phone, alt_phone) VALUES (?, ?, ?)
      `, ['Test Driver', '1234567890', '0987654321']);
      
      console.log('✅ Test driver created with ID:', driverResult.insertId);
      drivers.push({ id: driverResult.insertId, name: 'Test Driver' });
    }

    // Create test receipts for each driver
    for (const driver of drivers) {
      console.log(`\n🔧 Creating test receipts for driver: ${driver.name} (ID: ${driver.id})`);
      
      // Create 2-3 test receipts for each driver
      const testReceipts = [
        {
          bill_no: `RCP-${driver.id}-001`,
          payment_date: '2024-01-15',
          payment_amount: 1500.00,
          payment_mode: 'Cash',
          reference_number: '',
          notes: `Test receipt for ${driver.name}`,
          company_id: null,
          customer_id: null,
          driver_id: driver.id,
          bank_id: null,
          bunk_id: null
        },
        {
          bill_no: `RCP-${driver.id}-002`,
          payment_date: '2024-01-20',
          payment_amount: 2500.00,
          payment_mode: 'Bank Transfer',
          reference_number: 'TXN123456',
          notes: `Bank transfer receipt for ${driver.name}`,
          company_id: null,
          customer_id: null,
          driver_id: driver.id,
          bank_id: null,
          bunk_id: null
        },
        {
          bill_no: `RCP-${driver.id}-003`,
          payment_date: '2024-01-25',
          payment_amount: 3000.00,
          payment_mode: 'Cash',
          reference_number: '',
          notes: `Another receipt for ${driver.name}`,
          company_id: null,
          customer_id: null,
          driver_id: driver.id,
          bank_id: null,
          bunk_id: null
        }
      ];

      for (const receipt of testReceipts) {
        try {
          const [result] = await connection.execute(`
            INSERT INTO receipts (
              bill_no, payment_date, payment_amount, payment_mode, 
              reference_number, notes, company_id, customer_id, 
              driver_id, bank_id, bunk_id
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
          `, [
            receipt.bill_no,
            receipt.payment_date,
            receipt.payment_amount,
            receipt.payment_mode,
            receipt.reference_number,
            receipt.notes,
            receipt.company_id,
            receipt.customer_id,
            receipt.driver_id,
            receipt.bank_id,
            receipt.bunk_id
          ]);
          
          console.log(`  ✅ Created receipt: ${receipt.bill_no} (ID: ${result.insertId})`);
        } catch (error) {
          console.log(`  ❌ Error creating receipt ${receipt.bill_no}:`, error.message);
        }
      }
    }

    // Verify receipts were created
    console.log('\n📊 Verifying created receipts...');
    const [allReceipts] = await connection.execute(`
      SELECT id, driver_id, bill_no, payment_amount, payment_date, created_at
      FROM receipts 
      WHERE driver_id IS NOT NULL
      ORDER BY created_at DESC
    `);
    
    console.log(`📋 Total receipts with driver_id: ${allReceipts.length}`);
    allReceipts.forEach(r => console.log(`  - Receipt ${r.id}: Driver ID: ${r.driver_id}, Bill: ${r.bill_no}, Amount: ₹${r.payment_amount}`));

    // Test the backend route query for each driver
    for (const driver of drivers) {
      console.log(`\n🔍 Testing backend route for driver: ${driver.name} (ID: ${driver.id})`);
      
      const [driverReceipts] = await connection.execute(`
        SELECT DISTINCT
          r.id,
          r.company_id,
          r.driver_id,
          r.bill_no,
          DATE_FORMAT(r.payment_date, '%Y-%m-%d') as payment_date_formatted,
          r.payment_amount,
          r.payment_mode,
          r.reference_number,
          r.notes,
          r.bank_id,
          r.created_at,
          c.name as company_name,
          b.bank_name,
          b.account_number,
          b.ifsc_code,
          b.branch,
          b.account_name as bank_account_name,
          'receipt' as transaction_type
        FROM receipts r
        LEFT JOIN companies c ON r.company_id = c.id
        LEFT JOIN banks b ON r.bank_id = b.id
        WHERE r.driver_id = ?
        ORDER BY r.payment_date DESC, r.created_at DESC
      `, [driver.id]);
      
      console.log(`  📊 Receipts found for ${driver.name}: ${driverReceipts.length}`);
      driverReceipts.forEach(r => console.log(`    - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date_formatted}`));
    }

    console.log('\n✅ Test receipts creation completed!');
    console.log('🎯 Now test the driver dashboard - receipts should appear!');

  } catch (error) {
    console.error('❌ Error creating test receipts:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

createTestReceipts();











