const mysql = require('mysql2/promise');

async function debugDriverData() {
  let connection;
  
  try {
    // Create connection
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('Connected to database');

    // Check Kavitha Rani driver
    const [drivers] = await connection.execute(`
      SELECT id, name FROM drivers WHERE name LIKE '%Kavitha%'
    `);
    console.log('Kavitha drivers:', drivers);

    if (drivers.length > 0) {
      const driverId = drivers[0].id;
      const driverName = drivers[0].name;
      
      console.log(`\n=== DEBUGGING FOR DRIVER: ${driverName} (ID: ${driverId}) ===`);
      
      // Check receipts linked to this driver
      const [receipts] = await connection.execute(`
        SELECT id, driver_id, company_id, bill_no, payment_amount, payment_date
        FROM receipts 
        WHERE driver_id = ?
        ORDER BY payment_date DESC
        LIMIT 10
      `, [driverId]);
      console.log(`\nReceipts directly linked to driver (driver_id = ${driverId}):`, receipts.length);
      receipts.forEach(r => console.log(`  - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date}`));
      
      // Check receipts linked through companies
      const [companyReceipts] = await connection.execute(`
        SELECT r.id, r.driver_id, r.company_id, r.bill_no, r.payment_amount, r.payment_date, c.name as company_name
        FROM receipts r
        LEFT JOIN companies c ON r.company_id = c.id
        WHERE r.company_id IN (
          SELECT DISTINCT company_id
          FROM invoices
          WHERE driver_id = ? AND company_id IS NOT NULL
        )
        ORDER BY r.payment_date DESC
        LIMIT 10
      `, [driverId]);
      console.log(`\nReceipts linked through companies:`, companyReceipts.length);
      companyReceipts.forEach(r => console.log(`  - Receipt ${r.id}: ${r.bill_no}, Company: ${r.company_name}, Amount: ₹${r.payment_amount}`));
      
      // Check all receipts (to see what's being returned)
      const [allReceipts] = await connection.execute(`
        SELECT id, driver_id, company_id, bill_no, payment_amount, payment_date
        FROM receipts 
        ORDER BY payment_date DESC
        LIMIT 10
      `);
      console.log(`\nAll receipts in database:`, allReceipts.length);
      allReceipts.forEach(r => console.log(`  - Receipt ${r.id}: driver_id=${r.driver_id}, company_id=${r.company_id}, Amount: ₹${r.payment_amount}`));
      
      // Check diesel purchases
      const [dieselPurchases] = await connection.execute(`
        SELECT id, driver_name, bill_no, total_amount, bill_date
        FROM diesel_purchases 
        WHERE LOWER(TRIM(driver_name)) = LOWER(TRIM(?))
        ORDER BY bill_date DESC
        LIMIT 10
      `, [driverName]);
      console.log(`\nDiesel purchases for driver "${driverName}":`, dieselPurchases.length);
      dieselPurchases.forEach(d => console.log(`  - Diesel ${d.id}: ${d.bill_no}, Amount: ₹${d.total_amount}, Date: ${d.bill_date}`));
      
      // Check all diesel purchases to see what driver names exist
      const [allDiesel] = await connection.execute(`
        SELECT DISTINCT driver_name, COUNT(*) as count
        FROM diesel_purchases 
        WHERE driver_name IS NOT NULL
        GROUP BY driver_name
        ORDER BY count DESC
      `);
      console.log(`\nAll driver names in diesel_purchases:`, allDiesel);
      
    } else {
      console.log('No Kavitha driver found');
    }

  } catch (error) {
    console.error('❌ Error debugging driver data:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

debugDriverData();
