const mysql = require('mysql2/promise');

async function dropForeignKey() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== DROPPING FOREIGN KEY CONSTRAINT ===');
  
  try {
    // First, let's see what foreign keys exist
    console.log('Checking existing foreign key constraints...');
    const [constraints] = await connection.query(`
      SELECT 
        CONSTRAINT_NAME,
        COLUMN_NAME,
        REFERENCED_TABLE_NAME,
        REFERENCED_COLUMN_NAME
      FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
      WHERE TABLE_SCHEMA = 'cement' 
      AND TABLE_NAME = 'payment_entries'
      AND REFERENCED_TABLE_NAME IS NOT NULL
    `);
    
    console.log('Existing foreign key constraints:', constraints);
    
    // Try to drop the constraint
    if (constraints.length > 0) {
      for (const constraint of constraints) {
        try {
          console.log(`Dropping constraint: ${constraint.CONSTRAINT_NAME}`);
          await connection.query(`
            ALTER TABLE payment_entries 
            DROP FOREIGN KEY ${constraint.CONSTRAINT_NAME}
          `);
          console.log(`✅ Dropped ${constraint.CONSTRAINT_NAME}`);
        } catch (error) {
          console.log(`⚠️ Could not drop ${constraint.CONSTRAINT_NAME}: ${error.message}`);
        }
      }
    }
    
    console.log('🎉 Foreign key constraint removal completed!');
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  }
  
  await connection.end();
}

dropForeignKey().catch(console.error);










