const mysql = require('mysql2/promise');

async function findCompany() {
  let connection;
  
  try {
    // Create database connection
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });
    
    console.log('🔍 Connected to database successfully\n');
    
    // Search for companies with similar names
    console.log('📊 Searching for companies with "heeltec" in the name...');
    
    const [companies] = await connection.query(`
      SELECT id, name, created_at 
      FROM companies 
      WHERE LOWER(name) LIKE '%heeltec%'
      ORDER BY id
    `);
    
    console.log(`Found ${companies.length} companies with "heeltec" in name:`);
    companies.forEach(company => {
      console.log(`  - ID: ${company.id}, Name: "${company.name}", Created: ${company.created_at}`);
    });
    
    // Search for companies with "fix" in the name
    console.log('\n📊 Searching for companies with "fix" in the name...');
    
    const [fixCompanies] = await connection.query(`
      SELECT id, name, created_at 
      FROM companies 
      WHERE LOWER(name) LIKE '%fix%'
      ORDER BY id
    `);
    
    console.log(`Found ${fixCompanies.length} companies with "fix" in name:`);
    fixCompanies.forEach(company => {
      console.log(`  - ID: ${company.id}, Name: "${company.name}", Created: ${company.created_at}`);
    });
    
    // Search for companies with "h" at the end
    console.log('\n📊 Searching for companies ending with "h"...');
    
    const [hCompanies] = await connection.query(`
      SELECT id, name, created_at 
      FROM companies 
      WHERE LOWER(name) LIKE '%h'
      ORDER BY id
    `);
    
    console.log(`Found ${hCompanies.length} companies ending with "h":`);
    hCompanies.forEach(company => {
      console.log(`  - ID: ${company.id}, Name: "${company.name}", Created: ${company.created_at}`);
    });
    
    // Show all companies for reference
    console.log('\n📊 All companies in database:');
    const [allCompanies] = await connection.query(`
      SELECT id, name, created_at 
      FROM companies 
      ORDER BY id
    `);
    
    allCompanies.forEach(company => {
      console.log(`  - ID: ${company.id}, Name: "${company.name}", Created: ${company.created_at}`);
    });
    
    // Check receipts for the company
    console.log('\n📊 Checking receipts for companies with "heeltec"...');
    for (const company of companies) {
      const [receipts] = await connection.query(
        'SELECT COUNT(*) as count, SUM(payment_amount) as total FROM receipts WHERE company_id = ?',
        [company.id]
      );
      console.log(`  - ${company.name} (ID: ${company.id}): ${receipts[0].count} receipts, Total: ₹${receipts[0].total || 0}`);
    }
    
  } catch (error) {
    console.error('❌ Database error:', error.message);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\n✅ Database connection closed');
    }
  }
}

// Run the search
findCompany().catch(console.error);


