const mysql = require('mysql2/promise');

// Database configuration - update these values
const dbConfig = {
  host: 'localhost',
  user: 'root',
  password: '', // Update with your password
  database: 'cement' // Update with your database name
};

async function fixCompanyDetails() {
  let connection;
  
  try {
    console.log('Connecting to database...');
    connection = await mysql.createConnection(dbConfig);
    console.log('Connected successfully!');

    // Check company_details table structure
    console.log('\n=== Company Details Table Structure ===');
    const [columns] = await connection.execute('DESCRIBE company_details');
    columns.forEach(col => {
      console.log(`Column: ${col.Field}, Type: ${col.Type}, Null: ${col.Null}, Key: ${col.Key}, Default: ${col.Default}`);
    });

    // Check current company_details
    console.log('\n=== Current Company Details ===');
    const [companyDetails] = await connection.execute('SELECT * FROM company_details ORDER BY id');
    companyDetails.forEach(c => {
      console.log(`Company Details:`, c);
    });

    // Check companies table
    console.log('\n=== Companies Table ===');
    const [companies] = await connection.execute('SELECT * FROM companies ORDER BY id');
    companies.forEach(c => {
      console.log(`Company: ID ${c.id}, Name: ${c.name}, GST: ${c.gst}`);
    });

    // Try to add company ID 10 to company_details
    console.log('\n=== Adding Company ID 10 ===');
    try {
      // First, let's see what columns we can actually insert into
      const [existing] = await connection.execute('SELECT id FROM company_details WHERE id = ?', [10]);
      if (existing.length === 0) {
        // Try to insert with just the ID (since we don't know the exact structure)
        await connection.execute('INSERT INTO company_details (id) VALUES (?)', [10]);
        console.log('✅ Added company ID 10 to company_details');
      } else {
        console.log('ℹ️  Company ID 10 already exists in company_details');
      }
    } catch (err) {
      console.log(`❌ Error adding company ID 10: ${err.message}`);
      
      // Try alternative approach - check if we can update existing record
      try {
        const [updateResult] = await connection.execute('UPDATE company_details SET id = 10 WHERE id = 7');
        if (updateResult.affectedRows > 0) {
          console.log('✅ Updated company_details to include ID 10');
        }
      } catch (updateErr) {
        console.log(`❌ Update approach also failed: ${updateErr.message}`);
      }
    }

    // Final check
    console.log('\n=== Final Company Details ===');
    const [finalCompanyDetails] = await connection.execute('SELECT * FROM company_details ORDER BY id');
    finalCompanyDetails.forEach(c => {
      console.log(`Final Company Details:`, c);
    });

    // Check if payment entries can now be linked
    console.log('\n=== Testing Payment Entries Query ===');
    try {
      const [payments] = await connection.execute(`
        SELECT * FROM payment_entries 
        WHERE company_id = 10 OR company_id IS NULL
        ORDER BY id
      `);
      console.log(`Found ${payments.length} payment entries that could be linked to company 10`);
      payments.forEach(p => {
        console.log(`Payment ID: ${p.id}, Bill: ${p.bill_no}, Company ID: ${p.company_id}`);
      });
    } catch (err) {
      console.log(`❌ Error querying payment entries: ${err.message}`);
    }

  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed.');
    }
  }
}

// Run the script
fixCompanyDetails();
