const mysql = require('mysql2/promise');
require('dotenv').config();

const dbConfig = {
  host: process.env.DB_HOST || 'localhost',
  user: process.env.DB_USER || 'root',
  password: process.env.DB_PASSWORD || '',
  database: process.env.DB_NAME || 'cement',
};

async function fixCompanyForeignKey() {
  let connection;
  try {
    connection = await mysql.createConnection(dbConfig);
    console.log('✅ Connected to database');

    // Drop the old foreign key constraint
    console.log('\n🔧 Dropping old foreign key constraint...');
    try {
      await connection.execute(`
        ALTER TABLE payment_entries 
        DROP FOREIGN KEY payment_entries_ibfk_4
      `);
      console.log('✅ Old foreign key dropped');
    } catch (error) {
      console.log('⚠️ Foreign key might not exist or already dropped:', error.message);
    }

    // Add new foreign key constraint referencing companies table
    console.log('\n🔧 Adding new foreign key constraint to companies table...');
    await connection.execute(`
      ALTER TABLE payment_entries 
      ADD CONSTRAINT payment_entries_ibfk_4 
      FOREIGN KEY (company_id) REFERENCES companies(id) ON DELETE SET NULL
    `);
    console.log('✅ New foreign key added successfully');

    console.log('\n✅ Foreign key constraint updated successfully!');
    console.log('payment_entries.company_id now references companies(id)');

  } catch (error) {
    console.error('❌ Error fixing foreign key:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('✅ Database connection closed');
    }
  }
}

fixCompanyForeignKey();

