const mysql = require('mysql2/promise');

async function fixCompanyName() {
  let connection;
  
  try {
    // Create database connection
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });
    
    console.log('🔍 Connected to database successfully\n');
    
    // Find the company with the problematic name
    console.log('📊 Looking for company with name containing "heeltec fix it h"...');
    
    const [companies] = await connection.query(`
      SELECT id, name 
      FROM companies 
      WHERE LOWER(name) LIKE '%heeltec%' AND LOWER(name) LIKE '%fix%'
      ORDER BY id
    `);
    
    if (companies.length === 0) {
      console.log('❌ No company found with "heeltec fix it" in the name');
      return;
    }
    
    console.log(`Found ${companies.length} matching companies:`);
    companies.forEach(company => {
      console.log(`  - ID: ${company.id}, Current Name: "${company.name}"`);
    });
    
    // Fix the company name
    const companyId = companies[0].id;
    const currentName = companies[0].name;
    const newName = 'Heeltech Fix It'; // Proper name
    
    console.log(`\n🔧 Fixing company name:`);
    console.log(`  - Company ID: ${companyId}`);
    console.log(`  - Current Name: "${currentName}"`);
    console.log(`  - New Name: "${newName}"`);
    
    // Update the company name
    await connection.query(
      'UPDATE companies SET name = ? WHERE id = ?',
      [newName, companyId]
    );
    
    console.log('✅ Company name updated successfully!');
    
    // Verify the update
    const [updatedCompany] = await connection.query(
      'SELECT id, name FROM companies WHERE id = ?',
      [companyId]
    );
    
    console.log(`\n📊 Verification - Updated company:`);
    console.log(`  - ID: ${updatedCompany[0].id}`);
    console.log(`  - Name: "${updatedCompany[0].name}"`);
    
    // Check receipts for this company
    const [receipts] = await connection.query(
      'SELECT COUNT(*) as count, SUM(payment_amount) as total FROM receipts WHERE company_id = ?',
      [companyId]
    );
    
    console.log(`\n📊 Company receipts:`);
    console.log(`  - Total receipts: ${receipts[0].count}`);
    console.log(`  - Total amount: ₹${receipts[0].total || 0}`);
    
  } catch (error) {
    console.error('❌ Error fixing company name:', error.message);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\n✅ Database connection closed');
    }
  }
}

// Run the fix
fixCompanyName().catch(console.error);


