const mysql = require('mysql2/promise');

async function fixDieselTable() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('Connected to database');

    // Check if driver_name column exists
    const [columns] = await connection.execute(`
      SELECT COLUMN_NAME 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'diesel_purchases'
      AND COLUMN_NAME = 'driver_name'
    `);

    if (columns.length === 0) {
      console.log('Adding driver_name column to diesel_purchases table...');
      await connection.execute(`
        ALTER TABLE diesel_purchases 
        ADD COLUMN driver_name VARCHAR(255) NULL 
        AFTER vehicle_id
      `);
      console.log('✅ Added driver_name column to diesel_purchases table');
    } else {
      console.log('✅ driver_name column already exists in diesel_purchases table');
    }

    // Verify the column was added
    const [tableStructure] = await connection.execute(`
      DESCRIBE diesel_purchases
    `);
    console.log('diesel_purchases table structure:');
    tableStructure.forEach(col => {
      console.log(`  - ${col.Field}: ${col.Type} ${col.Null === 'YES' ? 'NULL' : 'NOT NULL'}`);
    });

  } catch (error) {
    console.error('❌ Error fixing diesel table:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('Database connection closed');
    }
  }
}

fixDieselTable();
