const mysql = require('mysql2/promise');

async function fixExistingDiesel() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== Fixing existing diesel purchase with bunk_id ===');
  
  try {
    // Update the existing diesel purchase (ID: 1) to have bunk_id = 1
    await connection.query(`
      UPDATE diesel_purchases 
      SET bunk_id = ? 
      WHERE id = ?
    `, [1, 1]);
    
    console.log('✅ Updated diesel purchase ID: 1 with bunk_id: 1');
    
    // Now check if it shows the bunk name
    const [updatedPurchase] = await connection.query(`
      SELECT dp.id, dp.bill_no, dp.bunk_id, b.bunk_name, dp.litres, dp.rate, dp.total_amount
      FROM diesel_purchases dp 
      LEFT JOIN bunks b ON dp.bunk_id = b.id
      WHERE dp.id = ?
    `, [1]);
    
    if (updatedPurchase.length > 0) {
      const purchase = updatedPurchase[0];
      console.log('✅ Updated purchase now shows:');
      console.log(`   ID: ${purchase.id}, Bill: ${purchase.bill_no}, Bunk ID: ${purchase.bunk_id}, Bunk Name: ${purchase.bunk_name || 'NULL'}`);
    }
    
  } catch (error) {
    console.error('❌ Error updating diesel purchase:', error.message);
  }
  
  await connection.end();
}

fixExistingDiesel().catch(console.error);
