const mysql = require('mysql2/promise');

// Database configuration - update these values
const dbConfig = {
  host: 'localhost',
  user: 'root',
  password: '', // Update with your password
  database: 'cement' // Update with your database name
};

async function linkPayments() {
  let connection;
  
  try {
    console.log('Connecting to database...');
    connection = await mysql.createConnection(dbConfig);
    console.log('Connected successfully!');

    // Update company ID 10 with the correct name
    console.log('\n=== Updating Company ID 10 ===');
    try {
      await connection.execute(
        'UPDATE company_details SET company_name = ? WHERE id = ?',
        ['jcs', 10]
      );
      console.log('✅ Updated company ID 10 with name "jcs"');
    } catch (err) {
      console.log(`❌ Error updating company name: ${err.message}`);
    }

    // Link existing payment entries to company ID 10
    console.log('\n=== Linking Payment Entries to Company 10 ===');
    
    // Get all payment entries that don't have a company_id
    const [unlinkedPayments] = await connection.execute(`
      SELECT id, bill_no, driver_name, vehicle_no 
      FROM payment_entries 
      WHERE company_id IS NULL
      ORDER BY id
    `);
    
    console.log(`Found ${unlinkedPayments.length} unlinked payment entries`);
    
    // Link them to company ID 10 (jcs)
    for (const payment of unlinkedPayments) {
      try {
        await connection.execute(
          'UPDATE payment_entries SET company_id = ? WHERE id = ?',
          [10, payment.id]
        );
        console.log(`✅ Linked Payment ID ${payment.id} (Bill: ${payment.bill_no}) to Company ID 10 (jcs)`);
      } catch (err) {
        console.log(`❌ Error linking Payment ID ${payment.id}: ${err.message}`);
      }
    }

    // Final check
    console.log('\n=== Final Payment Entries Status ===');
    const [finalPayments] = await connection.execute(`
      SELECT id, bill_no, company_id, driver_name, vehicle_no
      FROM payment_entries 
      ORDER BY id
    `);
    
    finalPayments.forEach(p => {
      const companyName = p.company_id === 10 ? 'jcs' : p.company_id === 8 ? 'Heel Tech' : 'None';
      console.log(`Payment ID: ${p.id}, Bill: ${p.bill_no}, Company: ${companyName} (ID: ${p.company_id})`);
    });

    // Test the company payments query
    console.log('\n=== Testing Company Payments Query ===');
    try {
      const [companyPayments] = await connection.execute(`
        SELECT * FROM payment_entries 
        WHERE company_id = 10
        ORDER BY id
      `);
      console.log(`Company ID 10 (jcs) now has ${companyPayments.length} payment entries`);
      companyPayments.forEach(p => {
        console.log(`- Payment ID: ${p.id}, Bill: ${p.bill_no}, Amount: ₹${p.total}`);
      });
    } catch (err) {
      console.log(`❌ Error testing company payments query: ${err.message}`);
    }

    console.log('\n✅ Payment linking completed!');
    console.log('\nNow refresh your company page - you should see the payment entries displayed!');

  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed.');
    }
  }
}

// Run the script
linkPayments();
