const mysql = require('mysql2/promise');

async function quickCheckReceipts() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });

  try {
    console.log('=== QUICK CHECK: RECEIPTS DATA ===\n');
    
    // Check total receipts
    const [count] = await connection.query('SELECT COUNT(*) as total FROM receipts');
    console.log(`Total receipts in database: ${count[0].total}`);
    
    if (count[0].total === 0) {
      console.log('No receipts found in database. This is why you\'re not seeing receipt data.');
      console.log('Run: node add-sample-receipts.js to add sample receipt data.');
      return;
    }
    
    // Check receipts with vehicle numbers
    const [vehicleReceipts] = await connection.query(`
      SELECT id, vehicle_no, bill_no, payment_amount, payment_date
      FROM receipts 
      WHERE vehicle_no IS NOT NULL AND vehicle_no != ""
      LIMIT 5
    `);
    
    console.log(`Receipts with vehicle numbers: ${vehicleReceipts.length}`);
    if (vehicleReceipts.length > 0) {
      vehicleReceipts.forEach(receipt => {
        console.log(`- Receipt ${receipt.id}: Vehicle "${receipt.vehicle_no}", Bill ${receipt.bill_no}, Amount ${receipt.payment_amount}`);
      });
    } else {
      console.log('No receipts have vehicle numbers populated.');
      console.log('This is why vehicle filtering is not working.');
    }
    
    // Show all receipts (first 5)
    const [allReceipts] = await connection.query(`
      SELECT id, vehicle_no, bill_no, payment_amount, payment_date, payment_mode, notes
      FROM receipts 
      ORDER BY id DESC 
      LIMIT 5
    `);
    
    console.log('\n=== ALL RECEIPTS (First 5) ===');
    allReceipts.forEach(receipt => {
      console.log(`Receipt ${receipt.id}:`);
      console.log(`  Vehicle No: "${receipt.vehicle_no || 'NULL'}"`);
      console.log(`  Bill No: ${receipt.bill_no}`);
      console.log(`  Amount: ${receipt.payment_amount}`);
      console.log(`  Date: ${receipt.payment_date}`);
      console.log(`  Mode: ${receipt.payment_mode}`);
      console.log(`  Notes: "${receipt.notes || 'NULL'}"`);
      console.log('');
    });
    
  } catch (error) {
    console.error('Error:', error.message);
  } finally {
    await connection.end();
  }
}

quickCheckReceipts();










