const mysql = require('mysql2/promise');

async function quickFixForeignKey() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== QUICK FIX FOR FOREIGN KEY ===');
  
  try {
    // Drop the problematic foreign key constraint
    console.log('Dropping foreign key constraint...');
    await connection.query(`
      ALTER TABLE payment_entries 
      DROP FOREIGN KEY payment_entries_ibfk_3
    `);
    console.log('✅ Dropped foreign key constraint');
    
    // Add new foreign key constraint pointing to expense_types
    console.log('Adding new foreign key constraint...');
    await connection.query(`
      ALTER TABLE payment_entries 
      ADD CONSTRAINT payment_entries_expense_type_fk 
      FOREIGN KEY (selected_expense_id) 
      REFERENCES expense_types(id) 
      ON DELETE SET NULL
    `);
    console.log('✅ Added new foreign key constraint to expense_types');
    
    console.log('🎉 Foreign key constraint fixed!');
    
  } catch (error) {
    console.error('Error:', error.message);
    
    if (error.code === 'ER_CANT_DROP_FIELD_OR_KEY') {
      console.log('Constraint name might be different. Trying alternative approach...');
      
      // Try to find and drop any foreign key on selected_expense_id
      try {
        await connection.query(`
          ALTER TABLE payment_entries 
          DROP CONSTRAINT payment_entries_ibfk_3
        `);
        console.log('✅ Dropped constraint with alternative method');
      } catch (e) {
        console.log('Could not drop constraint. The constraint might not exist or have a different name.');
        console.log('Continuing without foreign key constraint...');
      }
    }
  }
  
  await connection.end();
}

quickFixForeignKey().catch(console.error);

