const mysql = require('mysql2/promise');

async function removeTestData() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== REMOVING TEST DATA ===');
  
  try {
    // Remove test payment entries
    console.log('\n1. Removing test payment entries...');
    const [paymentResult] = await connection.query(`
      DELETE FROM payment_entries 
      WHERE bill_no LIKE 'TEST-%' 
      OR bill_no LIKE 'PE00%'
      OR note LIKE '%Test%'
      OR note LIKE '%test%'
      OR driver_name LIKE '%Test%'
      OR vehicle_no LIKE 'TEST-%'
    `);
    console.log(`✅ Removed ${paymentResult.affectedRows} test payment entries`);
    
    // Remove test expenses
    console.log('\n2. Removing test expenses...');
    const [expenseResult] = await connection.query(`
      DELETE FROM expenses 
      WHERE type LIKE '%test%'
      OR type LIKE '%Test%'
      OR vehicle_number LIKE 'TEST-%'
      OR driver_name LIKE '%Test%'
    `);
    console.log(`✅ Removed ${expenseResult.affectedRows} test expenses`);
    
    // Remove test diesel purchases
    console.log('\n3. Removing test diesel purchases...');
    const [dieselResult] = await connection.query(`
      DELETE FROM diesel_purchases 
      WHERE bill_no LIKE 'TEST-%'
      OR bill_no LIKE 'DP00%'
      OR vehicle_number LIKE 'TEST-%'
      OR driver_name LIKE '%Test%'
      OR notes LIKE '%Test%'
      OR notes LIKE '%test%'
    `);
    console.log(`✅ Removed ${dieselResult.affectedRows} test diesel purchases`);
    
    // Remove test receipts
    console.log('\n4. Removing test receipts...');
    const [receiptResult] = await connection.query(`
      DELETE FROM receipts 
      WHERE bill_no LIKE 'TEST-%'
      OR payment_mode LIKE '%Test%'
      OR notes LIKE '%Test%'
      OR notes LIKE '%test%'
    `);
    console.log(`✅ Removed ${receiptResult.affectedRows} test receipts`);
    
    // Check for any remaining test data
    console.log('\n5. Checking for remaining test data...');
    
    const [remainingPayments] = await connection.query(`
      SELECT COUNT(*) as count FROM payment_entries 
      WHERE bill_no LIKE '%TEST%' 
      OR note LIKE '%test%'
      OR driver_name LIKE '%Test%'
    `);
    console.log(`Remaining test payment entries: ${remainingPayments[0].count}`);
    
    const [remainingExpenses] = await connection.query(`
      SELECT COUNT(*) as count FROM expenses 
      WHERE type LIKE '%test%'
      OR vehicle_number LIKE '%TEST%'
    `);
    console.log(`Remaining test expenses: ${remainingExpenses[0].count}`);
    
    const [remainingDiesel] = await connection.query(`
      SELECT COUNT(*) as count FROM diesel_purchases 
      WHERE bill_no LIKE '%TEST%'
      OR vehicle_number LIKE '%TEST%'
    `);
    console.log(`Remaining test diesel purchases: ${remainingDiesel[0].count}`);
    
    console.log('\n🎉 Test data cleanup completed!');
    
  } catch (error) {
    console.error('❌ Error during cleanup:', error.message);
  }
  
  await connection.end();
}

removeTestData().catch(console.error);










