const express = require('express');
const router = express.Router();
const mysql = require('mysql2/promise');
const crypto = require('crypto');

// MySQL connection pool (will be passed from server.js)
let db;
function setDb(pool) { db = pool; }

function sha256(str) {
  return crypto.createHash('sha256').update(str).digest('hex');
}

// Test route to verify database connection
router.get('/test', async (req, res) => {
  try {
    const [rows] = await db.query('SELECT 1 as test');
    res.json({ message: 'Database connected successfully', test: rows[0] });
  } catch (err) {
    console.error('Database test error:', err);
    res.status(500).json({ message: 'Database connection failed', error: err.message });
  }
});

// Admin login route
router.post('/login', async (req, res) => {
  const { username, password } = req.body;
  
  console.log('Login attempt:', { username, password: password ? '***' : 'undefined' });
  
  if (!username || !password) {
    return res.status(400).json({ message: 'Username and password are required' });
  }

  try {
    // Test database connection first
    await db.query('SELECT 1');
    
    const [rows] = await db.query('SELECT * FROM admins WHERE username = ?', [username]);
    console.log('Found users:', rows.length);
    
    if (rows.length === 0) {
      console.log('No user found with username:', username);
      return res.status(401).json({ message: 'Invalid username or password' });
    }
    
    const admin = rows[0];
    console.log('User found:', { id: admin.id, username: admin.username, hasPassword: !!admin.password });
    
    const hashedInput = sha256(password);
    const match = hashedInput === admin.password;
    console.log('Password match:', match);
    
    if (!match) {
      return res.status(401).json({ message: 'Invalid username or password' });
    }
    
    res.json({ success: true, username: admin.username });
  } catch (err) {
    console.error('Login error:', err);
    res.status(500).json({ message: 'Server error', error: err.message });
  }
});

module.exports = { router, setDb }; 