const express = require('express');
const router = express.Router();
const { getNextGlobalSequentialBillNumber, isBillNumberExists } = require('../utils/sequentialBillNumber');

// Get next sequential bill number
router.get('/next', async (req, res) => {
  try {
    const nextBillNo = await getNextGlobalSequentialBillNumber();
    res.json({ bill_no: nextBillNo });
  } catch (error) {
    console.error('Error getting next bill number:', error);
    res.status(500).json({ error: 'Failed to get next bill number' });
  }
});

// Check if bill number exists
router.get('/check/:billNo', async (req, res) => {
  try {
    const { billNo } = req.params;
    const exists = await isBillNumberExists(billNo);
    res.json({ exists, bill_no: billNo });
  } catch (error) {
    console.error('Error checking bill number:', error);
    res.status(500).json({ error: 'Failed to check bill number' });
  }
});

module.exports = router;





