const express = require('express');
const router = express.Router();
const mysql = require('mysql2/promise');

// MySQL connection pool (will be passed from server.js)
let db;
function setDb(pool) { db = pool; }

// Get settings
router.get('/', async (req, res) => {
  try {
    const [rows] = await db.query('SELECT * FROM settings LIMIT 1');
    if (rows.length > 0) {
      res.json(rows[0]);
    } else {
      res.json({
        company_name: '',
        address: '',
        city: '',
        phone: '',
        email: '',
        pan: '',
        bank_name: '',
        account_number: '',
        ifsc: '',
        branch: '',
        account_name: ''
      });
    }
  } catch (err) {
    console.error('Error fetching settings:', err);
    res.status(500).json({ message: 'Server error', error: err.message });
  }
});

// Update settings
router.put('/', async (req, res) => {
  const {
    company_name,
    address,
    city,
    phone,
    email,
    pan,
    bank_name,
    account_number,
    ifsc,
    branch,
    account_name
  } = req.body;

  try {
    // Check if settings exist
    const [existing] = await db.query('SELECT id FROM settings LIMIT 1');
    
    if (existing.length > 0) {
      // Update existing settings
      await db.query(
        'UPDATE settings SET company_name=?, address=?, city=?, phone=?, email=?, pan=?, bank_name=?, account_number=?, ifsc=?, branch=?, account_name=? WHERE id=?',
        [company_name, address, city, phone, email, pan, bank_name, account_number, ifsc, branch, account_name, existing[0].id]
      );
    } else {
      // Insert new settings
      await db.query(
        'INSERT INTO settings (company_name, address, city, phone, email, pan, bank_name, account_number, ifsc, branch, account_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
        [company_name, address, city, phone, email, pan, bank_name, account_number, ifsc, branch, account_name]
      );
    }
    
    res.json({ message: 'Settings updated successfully' });
  } catch (err) {
    console.error('Error updating settings:', err);
    res.status(500).json({ message: 'Server error', error: err.message });
  }
});

module.exports = { router, setDb }; 