const mysql = require('mysql2/promise');

async function testApiEndpoints() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔍 Testing API endpoints data availability...\n');

    // Test invoices
    try {
      const [invoices] = await connection.execute('SELECT COUNT(*) as count FROM invoices');
      console.log(`📊 Invoices: ${invoices[0].count} records`);
    } catch (error) {
      console.log('❌ Invoices table error:', error.message);
    }

    // Test vehicles
    try {
      const [vehicles] = await connection.execute('SELECT COUNT(*) as count FROM vehicles');
      console.log(`🚛 Vehicles: ${vehicles[0].count} records`);
    } catch (error) {
      console.log('❌ Vehicles table error:', error.message);
    }

    // Test customers
    try {
      const [customers] = await connection.execute('SELECT COUNT(*) as count FROM customers');
      console.log(`👥 Customers: ${customers[0].count} records`);
    } catch (error) {
      console.log('❌ Customers table error:', error.message);
    }

    // Test drivers
    try {
      const [drivers] = await connection.execute('SELECT COUNT(*) as count FROM drivers');
      console.log(`🚗 Drivers: ${drivers[0].count} records`);
    } catch (error) {
      console.log('❌ Drivers table error:', error.message);
    }

    // Test payment entries
    try {
      const [payments] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
      console.log(`💳 Payment Entries: ${payments[0].count} records`);
    } catch (error) {
      console.log('❌ Payment Entries table error:', error.message);
    }

    // Test diesel purchases
    try {
      const [diesel] = await connection.execute('SELECT COUNT(*) as count FROM diesel_purchases');
      console.log(`⛽ Diesel Purchases: ${diesel[0].count} records`);
    } catch (error) {
      console.log('❌ Diesel Purchases table error:', error.message);
    }

    // Test receipts
    try {
      const [receipts] = await connection.execute('SELECT COUNT(*) as count FROM receipts');
      console.log(`🧾 Receipts: ${receipts[0].count} records`);
    } catch (error) {
      console.log('❌ Receipts table error:', error.message);
    }

    // Test companies
    try {
      const [companies] = await connection.execute('SELECT COUNT(*) as count FROM companies');
      console.log(`🏢 Companies: ${companies[0].count} records`);
    } catch (error) {
      console.log('❌ Companies table error:', error.message);
    }

    // Test bunks
    try {
      const [bunks] = await connection.execute('SELECT COUNT(*) as count FROM bunks');
      console.log(`🏪 Bunks: ${bunks[0].count} records`);
    } catch (error) {
      console.log('❌ Bunks table error:', error.message);
    }

    // Test banks
    try {
      const [banks] = await connection.execute('SELECT COUNT(*) as count FROM banks');
      console.log(`🏦 Banks: ${banks[0].count} records`);
    } catch (error) {
      console.log('❌ Banks table error:', error.message);
    }

    console.log('\n🔍 Testing specific data for dashboard...');

    // Test today's invoices
    const today = new Date().toISOString().slice(0, 10);
    try {
      const [todayInvoices] = await connection.execute(`
        SELECT COUNT(*) as count 
        FROM invoices 
        WHERE DATE(supplier_invoice_date) = ?
      `, [today]);
      console.log(`📅 Today's Invoices: ${todayInvoices[0].count} records`);
    } catch (error) {
      console.log('❌ Today invoices error:', error.message);
    }

    // Test today's payment entries
    try {
      const [todayPayments] = await connection.execute(`
        SELECT COUNT(*) as count 
        FROM payment_entries 
        WHERE DATE(bill_date) = ?
      `, [today]);
      console.log(`📅 Today's Payment Entries: ${todayPayments[0].count} records`);
    } catch (error) {
      console.log('❌ Today payments error:', error.message);
    }

    // Test today's diesel purchases
    try {
      const [todayDiesel] = await connection.execute(`
        SELECT COUNT(*) as count 
        FROM diesel_purchases 
        WHERE DATE(purchase_date) = ?
      `, [today]);
      console.log(`📅 Today's Diesel Purchases: ${todayDiesel[0].count} records`);
    } catch (error) {
      console.log('❌ Today diesel error:', error.message);
    }

    console.log('\n✅ API endpoint test completed!');
    console.log('💡 If any counts are 0, that explains why dashboard shows no data');

  } catch (error) {
    console.error('❌ Database connection error:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

testApiEndpoints();

async function testApiEndpoints() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔍 Testing API endpoints data availability...\n');

    // Test invoices
    try {
      const [invoices] = await connection.execute('SELECT COUNT(*) as count FROM invoices');
      console.log(`📊 Invoices: ${invoices[0].count} records`);
    } catch (error) {
      console.log('❌ Invoices table error:', error.message);
    }

    // Test vehicles
    try {
      const [vehicles] = await connection.execute('SELECT COUNT(*) as count FROM vehicles');
      console.log(`🚛 Vehicles: ${vehicles[0].count} records`);
    } catch (error) {
      console.log('❌ Vehicles table error:', error.message);
    }

    // Test customers
    try {
      const [customers] = await connection.execute('SELECT COUNT(*) as count FROM customers');
      console.log(`👥 Customers: ${customers[0].count} records`);
    } catch (error) {
      console.log('❌ Customers table error:', error.message);
    }

    // Test drivers
    try {
      const [drivers] = await connection.execute('SELECT COUNT(*) as count FROM drivers');
      console.log(`🚗 Drivers: ${drivers[0].count} records`);
    } catch (error) {
      console.log('❌ Drivers table error:', error.message);
    }

    // Test payment entries
    try {
      const [payments] = await connection.execute('SELECT COUNT(*) as count FROM payment_entries');
      console.log(`💳 Payment Entries: ${payments[0].count} records`);
    } catch (error) {
      console.log('❌ Payment Entries table error:', error.message);
    }

    // Test diesel purchases
    try {
      const [diesel] = await connection.execute('SELECT COUNT(*) as count FROM diesel_purchases');
      console.log(`⛽ Diesel Purchases: ${diesel[0].count} records`);
    } catch (error) {
      console.log('❌ Diesel Purchases table error:', error.message);
    }

    // Test receipts
    try {
      const [receipts] = await connection.execute('SELECT COUNT(*) as count FROM receipts');
      console.log(`🧾 Receipts: ${receipts[0].count} records`);
    } catch (error) {
      console.log('❌ Receipts table error:', error.message);
    }

    // Test companies
    try {
      const [companies] = await connection.execute('SELECT COUNT(*) as count FROM companies');
      console.log(`🏢 Companies: ${companies[0].count} records`);
    } catch (error) {
      console.log('❌ Companies table error:', error.message);
    }

    // Test bunks
    try {
      const [bunks] = await connection.execute('SELECT COUNT(*) as count FROM bunks');
      console.log(`🏪 Bunks: ${bunks[0].count} records`);
    } catch (error) {
      console.log('❌ Bunks table error:', error.message);
    }

    // Test banks
    try {
      const [banks] = await connection.execute('SELECT COUNT(*) as count FROM banks');
      console.log(`🏦 Banks: ${banks[0].count} records`);
    } catch (error) {
      console.log('❌ Banks table error:', error.message);
    }

    console.log('\n🔍 Testing specific data for dashboard...');

    // Test today's invoices
    const today = new Date().toISOString().slice(0, 10);
    try {
      const [todayInvoices] = await connection.execute(`
        SELECT COUNT(*) as count 
        FROM invoices 
        WHERE DATE(supplier_invoice_date) = ?
      `, [today]);
      console.log(`📅 Today's Invoices: ${todayInvoices[0].count} records`);
    } catch (error) {
      console.log('❌ Today invoices error:', error.message);
    }

    // Test today's payment entries
    try {
      const [todayPayments] = await connection.execute(`
        SELECT COUNT(*) as count 
        FROM payment_entries 
        WHERE DATE(bill_date) = ?
      `, [today]);
      console.log(`📅 Today's Payment Entries: ${todayPayments[0].count} records`);
    } catch (error) {
      console.log('❌ Today payments error:', error.message);
    }

    // Test today's diesel purchases
    try {
      const [todayDiesel] = await connection.execute(`
        SELECT COUNT(*) as count 
        FROM diesel_purchases 
        WHERE DATE(purchase_date) = ?
      `, [today]);
      console.log(`📅 Today's Diesel Purchases: ${todayDiesel[0].count} records`);
    } catch (error) {
      console.log('❌ Today diesel error:', error.message);
    }

    console.log('\n✅ API endpoint test completed!');
    console.log('💡 If any counts are 0, that explains why dashboard shows no data');

  } catch (error) {
    console.error('❌ Database connection error:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

testApiEndpoints();


























