const axios = require('axios');

const API_BASE = 'http://localhost:5000/api';

async function testBackendStatus() {
  console.log('🔍 Testing Backend Status...\n');
  
  try {
    // Test 1: Basic connectivity
    console.log('📊 Test 1: Basic server connectivity...');
    try {
      const response = await axios.get(`${API_BASE}/companies/all`, { timeout: 5000 });
      console.log('✅ Backend server is running and accessible');
      console.log('✅ Companies endpoint is working');
      
      const companies = Array.isArray(response.data) ? response.data : response.data.companies || [];
      console.log(`✅ Found ${companies.length} companies:`);
      companies.forEach(company => {
        console.log(`  - ID: ${company.id}, Name: "${company.name}"`);
      });
      
      return companies;
    } catch (error) {
      console.log('❌ Backend server connection failed:', error.message);
      if (error.code === 'ECONNREFUSED') {
        console.log('💡 Solution: Start the backend server with: npm start');
        console.log('💡 Make sure the server is running on port 5000');
      } else if (error.response) {
        console.log('💡 Server responded with error:', error.response.status, error.response.statusText);
        console.log('💡 Response data:', error.response.data);
      }
      return [];
    }
    
  } catch (error) {
    console.error('❌ General error:', error.message);
    return [];
  }
}

// Run the test
testBackendStatus().catch(console.error);


