const mysql = require('mysql2/promise');

async function testBunkDiesel() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== Checking available vehicles ===');
  
  try {
    // First check what vehicles exist
    const [vehicles] = await connection.query('SELECT id, number, name FROM vehicles LIMIT 5');
    console.log('Available vehicles:');
    vehicles.forEach(v => {
      console.log(`   ID: ${v.id}, Number: ${v.number}, Name: ${v.name}`);
    });
    
    if (vehicles.length > 0) {
      const vehicleId = vehicles[0].id;
      console.log(`\n=== Creating test diesel purchase with vehicle_id=${vehicleId} and bunk_id=1 ===`);
      
      // Create a test diesel purchase with valid vehicle_id and bunk_id = 1 (Indus oil)
      const [result] = await connection.query(`
        INSERT INTO diesel_purchases (bill_no, bill_date, vehicle_id, driver_name, litres, rate, total_amount, bunk_id)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
      `, ['TEST002', '2025-01-20', vehicleId, 'Test Driver', 50, 100, 5000, 1]);
      
      console.log('✅ Test diesel purchase created with ID:', result.insertId);
      
      // Now check if it shows the bunk name
      const [testPurchase] = await connection.query(`
        SELECT dp.id, dp.bill_no, dp.bunk_id, b.bunk_name, dp.litres, dp.rate, dp.total_amount
        FROM diesel_purchases dp 
        LEFT JOIN bunks b ON dp.bunk_id = b.id
        WHERE dp.id = ?
      `, [result.insertId]);
      
      if (testPurchase.length > 0) {
        const purchase = testPurchase[0];
        console.log('✅ Test purchase shows:');
        console.log(`   ID: ${purchase.id}, Bill: ${purchase.bill_no}, Bunk ID: ${purchase.bunk_id}, Bunk Name: ${purchase.bunk_name || 'NULL'}`);
      }
    } else {
      console.log('❌ No vehicles found in database');
    }
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  }
  
  await connection.end();
}

testBunkDiesel().catch(console.error);
