const mysql = require('mysql2/promise');

async function testDieselRoute() {
  let connection;
  
  try {
    // Create connection
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('Connected to database');

    // Check if driver_name column exists
    const [columns] = await connection.execute(`
      SELECT COLUMN_NAME 
      FROM INFORMATION_SCHEMA.COLUMNS 
      WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'diesel_purchases'
      AND COLUMN_NAME = 'driver_name'
    `);

    if (columns.length === 0) {
      console.log('❌ driver_name column does not exist in diesel_purchases table');
      console.log('Adding driver_name column...');
      
      await connection.execute(`
        ALTER TABLE diesel_purchases 
        ADD COLUMN driver_name VARCHAR(255) NULL 
        AFTER vehicle_id
      `);
      console.log('✅ Added driver_name column');
    } else {
      console.log('✅ driver_name column exists');
    }

    // Check all driver names in diesel_purchases
    const [allDrivers] = await connection.execute(`
      SELECT DISTINCT driver_name, COUNT(*) as count
      FROM diesel_purchases 
      WHERE driver_name IS NOT NULL
      GROUP BY driver_name
      ORDER BY count DESC
    `);
    console.log('All driver names in diesel_purchases:', allDrivers);

    // Check Kavitha Rani specifically
    const [kavithaDiesel] = await connection.execute(`
      SELECT id, driver_name, bill_no, total_amount, bill_date
      FROM diesel_purchases 
      WHERE LOWER(TRIM(driver_name)) LIKE '%kavitha%'
      ORDER BY bill_date DESC
    `);
    console.log('Kavitha diesel purchases:', kavithaDiesel);

    // Test the exact query used in the route
    const driverName = 'Kavitha Rani';
    const [testQuery] = await connection.execute(`
      SELECT dp.*, v.number as vehicle_number, v.name as vehicle_name, b.bunk_name
      FROM diesel_purchases dp 
      LEFT JOIN vehicles v ON dp.vehicle_id = v.id
      LEFT JOIN bunks b ON dp.bunk_id = b.id
      WHERE LOWER(TRIM(dp.driver_name)) = LOWER(TRIM(?))
      ORDER BY dp.bill_date DESC
    `, [driverName]);
    console.log(`Test query for "${driverName}":`, testQuery.length, 'results');

  } catch (error) {
    console.error('❌ Error testing diesel route:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

testDieselRoute();
