const mysql = require('mysql2/promise');

async function testPaymentWithExpenseType() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'cement'
  });
  
  console.log('=== TESTING PAYMENT WITH EXPENSE TYPE ===');
  
  try {
    // First, get a diesel expense type ID
    const [dieselTypes] = await connection.query('SELECT id, name FROM expense_types WHERE name = ?', ['Diesel']);
    
    if (dieselTypes.length === 0) {
      console.log('No Diesel expense type found. Creating one...');
      const [result] = await connection.query(
        'INSERT INTO expense_types (name, description, category) VALUES (?, ?, ?)',
        ['Diesel', 'Fuel expenses', 'fuel']
      );
      console.log('Created Diesel expense type with ID:', result.insertId);
    } else {
      console.log('Found Diesel expense type:', dieselTypes[0]);
    }
    
    // Create a test payment entry with expense type
    const dieselTypeId = dieselTypes.length > 0 ? dieselTypes[0].id : result.insertId;
    
    const [paymentResult] = await connection.query(
      `INSERT INTO payment_entries (
        bill_no, bill_date, account_type_bank_name, driver_name, vehicle_no, 
        selected_expense_id, expense_amount, total, note
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)`,
      [
        'TEST-001',
        new Date(),
        'Cash',
        'Test Driver',
        'KA-TEST-123',
        dieselTypeId,
        2500,
        2500,
        'Test payment for diesel expense type'
      ]
    );
    
    console.log('✅ Created test payment entry with ID:', paymentResult.insertId);
    
    // Verify the payment was created correctly
    const [verification] = await connection.query(
      `SELECT pe.*, et.name as expense_type_name 
       FROM payment_entries pe 
       LEFT JOIN expense_types et ON pe.selected_expense_id = et.id 
       WHERE pe.id = ?`,
      [paymentResult.insertId]
    );
    
    console.log('✅ Verification - Payment with expense type:', verification[0]);
    
  } catch (error) {
    console.error('Error:', error.message);
  }
  
  await connection.end();
}

testPaymentWithExpenseType().catch(console.error);
