const mysql = require('mysql2/promise');

// Database configuration - update these values
const dbConfig = {
  host: 'localhost',
  user: 'root',
  password: '', // Update with your password
  database: 'cement' // Update with your database name
};

async function testPayments() {
  let connection;
  
  try {
    console.log('Connecting to database...');
    connection = await mysql.createConnection(dbConfig);
    console.log('Connected successfully!');

    // Test company ID 10 (jcs)
    console.log('\n=== Testing Company ID 10 (jcs) ===');
    const [payments10] = await connection.execute(`
      SELECT pe.*, b.bunk_name, bk.bank_name
      FROM payment_entries pe
      LEFT JOIN bunks b ON pe.bunk_id = b.id
      LEFT JOIN banks bk ON pe.bank_id = bk.id
      WHERE pe.company_id = ?
      ORDER BY pe.bill_date DESC
    `, [10]);
    
    console.log(`Found ${payments10.length} payments for company ID 10`);
    payments10.forEach(p => {
      console.log(`- Payment ID: ${p.id}, Bill: ${p.bill_no}, Amount: ₹${p.total}, Company ID: ${p.company_id}`);
    });

    // Test company ID 8 (Heel Tech)
    console.log('\n=== Testing Company ID 8 (Heel Tech) ===');
    const [payments8] = await connection.execute(`
      SELECT pe.*, b.bunk_name, bk.bank_name
      FROM payment_entries pe
      LEFT JOIN bunks b ON pe.bunk_id = b.id
      LEFT JOIN banks bk ON pe.bank_id = bk.id
      WHERE pe.company_id = ?
      ORDER BY pe.bill_date DESC
    `, [8]);
    
    console.log(`Found ${payments8.length} payments for company ID 8`);
    payments8.forEach(p => {
      console.log(`- Payment ID: ${p.id}, Bill: ${p.bill_no}, Amount: ₹${p.total}, Company ID: ${p.company_id}`);
    });

    // Check all payment entries
    console.log('\n=== All Payment Entries ===');
    const [allPayments] = await connection.execute(`
      SELECT id, bill_no, company_id, total, driver_name
      FROM payment_entries 
      ORDER BY id
    `);
    
    allPayments.forEach(p => {
      const companyName = p.company_id === 10 ? 'jcs' : p.company_id === 8 ? 'Heel Tech' : 'None';
      console.log(`Payment ID: ${p.id}, Bill: ${p.bill_no}, Company: ${companyName} (ID: ${p.company_id}), Amount: ₹${p.total}`);
    });

  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed.');
    }
  }
}

// Run the script
testPayments();
