const mysql = require('mysql2/promise');

async function testReceiptsAPI() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔍 Testing receipts API for drivers...');

    // Check all drivers
    const [drivers] = await connection.execute('SELECT id, name FROM drivers ORDER BY id');
    console.log('\n📋 All drivers:');
    drivers.forEach(d => console.log(`  - ID: ${d.id}, Name: "${d.name}"`));

    // Check all receipts
    const [allReceipts] = await connection.execute(`
      SELECT id, driver_id, bill_no, payment_amount, payment_date, created_at
      FROM receipts 
      ORDER BY created_at DESC 
      LIMIT 20
    `);
    console.log('\n📋 All receipts:');
    allReceipts.forEach(r => console.log(`  - Receipt ${r.id}: Driver ID: ${r.driver_id}, Bill: ${r.bill_no}, Amount: ₹${r.payment_amount}`));

    // Test the exact backend route query for each driver
    for (const driver of drivers) {
      console.log(`\n🔍 Testing backend route for driver: "${driver.name}" (ID: ${driver.id})`);
      
      try {
        const [driverReceipts] = await connection.execute(`
          SELECT DISTINCT
            r.id,
            r.company_id,
            r.driver_id,
            r.bill_no,
            DATE_FORMAT(r.payment_date, '%Y-%m-%d') as payment_date_formatted,
            r.payment_amount,
            r.payment_mode,
            r.reference_number,
            r.notes,
            r.bank_id,
            r.created_at,
            c.name as company_name,
            b.bank_name,
            b.account_number,
            b.ifsc_code,
            b.branch,
            b.account_name as bank_account_name,
            'receipt' as transaction_type
          FROM receipts r
          LEFT JOIN companies c ON r.company_id = c.id
          LEFT JOIN banks b ON r.bank_id = b.id
          WHERE r.driver_id = ?
          ORDER BY r.payment_date DESC, r.created_at DESC
        `, [driver.id]);
        
        console.log(`  📊 Receipts found: ${driverReceipts.length}`);
        driverReceipts.forEach(r => console.log(`    - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date_formatted}`));
        
        if (driverReceipts.length === 0) {
          console.log(`  ⚠️ No receipts found for driver ${driver.name} (ID: ${driver.id})`);
        }
      } catch (error) {
        console.log(`  ❌ Error testing driver ${driver.name}:`, error.message);
      }
    }

    // Create a test receipt for the first driver if none exist
    if (drivers.length > 0) {
      const testDriver = drivers[0];
      console.log(`\n🧪 Creating test receipt for driver: ${testDriver.name} (ID: ${testDriver.id})`);
      
      try {
        const [result] = await connection.execute(`
          INSERT INTO receipts (
            bill_no, payment_date, payment_amount, payment_mode, 
            reference_number, notes, company_id, customer_id, 
            driver_id, bank_id, bunk_id
          ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        `, [
          'TEST-RECEIPT-' + Date.now(),
          '2024-01-15',
          1500.00,
          'Cash',
          '',
          'Test receipt for driver',
          null,
          null,
          testDriver.id,
          null,
          null
        ]);
        
        console.log(`✅ Test receipt created with ID: ${result.insertId}`);
        
        // Test the query again
        const [testReceipts] = await connection.execute(`
          SELECT DISTINCT
            r.id,
            r.company_id,
            r.driver_id,
            r.bill_no,
            DATE_FORMAT(r.payment_date, '%Y-%m-%d') as payment_date_formatted,
            r.payment_amount,
            r.payment_mode,
            r.reference_number,
            r.notes,
            r.bank_id,
            r.created_at,
            c.name as company_name,
            b.bank_name,
            b.account_number,
            b.ifsc_code,
            b.branch,
            b.account_name as bank_account_name,
            'receipt' as transaction_type
          FROM receipts r
          LEFT JOIN companies c ON r.company_id = c.id
          LEFT JOIN banks b ON r.bank_id = b.id
          WHERE r.driver_id = ?
          ORDER BY r.payment_date DESC, r.created_at DESC
        `, [testDriver.id]);
        
        console.log(`📊 Test receipts found: ${testReceipts.length}`);
        testReceipts.forEach(r => console.log(`  - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}`));
        
      } catch (error) {
        console.log(`❌ Error creating test receipt:`, error.message);
      }
    }

  } catch (error) {
    console.error('❌ Error testing receipts API:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

testReceiptsAPI();


async function testReceiptsAPI() {
  let connection;
  
  try {
    connection = await mysql.createConnection({
      host: 'localhost',
      user: 'root',
      password: '',
      database: 'cement_management'
    });

    console.log('🔍 Testing receipts API for drivers...');

    // Check all drivers
    const [drivers] = await connection.execute('SELECT id, name FROM drivers ORDER BY id');
    console.log('\n📋 All drivers:');
    drivers.forEach(d => console.log(`  - ID: ${d.id}, Name: "${d.name}"`));

    // Check all receipts
    const [allReceipts] = await connection.execute(`
      SELECT id, driver_id, bill_no, payment_amount, payment_date, created_at
      FROM receipts 
      ORDER BY created_at DESC 
      LIMIT 20
    `);
    console.log('\n📋 All receipts:');
    allReceipts.forEach(r => console.log(`  - Receipt ${r.id}: Driver ID: ${r.driver_id}, Bill: ${r.bill_no}, Amount: ₹${r.payment_amount}`));

    // Test the exact backend route query for each driver
    for (const driver of drivers) {
      console.log(`\n🔍 Testing backend route for driver: "${driver.name}" (ID: ${driver.id})`);
      
      try {
        const [driverReceipts] = await connection.execute(`
          SELECT DISTINCT
            r.id,
            r.company_id,
            r.driver_id,
            r.bill_no,
            DATE_FORMAT(r.payment_date, '%Y-%m-%d') as payment_date_formatted,
            r.payment_amount,
            r.payment_mode,
            r.reference_number,
            r.notes,
            r.bank_id,
            r.created_at,
            c.name as company_name,
            b.bank_name,
            b.account_number,
            b.ifsc_code,
            b.branch,
            b.account_name as bank_account_name,
            'receipt' as transaction_type
          FROM receipts r
          LEFT JOIN companies c ON r.company_id = c.id
          LEFT JOIN banks b ON r.bank_id = b.id
          WHERE r.driver_id = ?
          ORDER BY r.payment_date DESC, r.created_at DESC
        `, [driver.id]);
        
        console.log(`  📊 Receipts found: ${driverReceipts.length}`);
        driverReceipts.forEach(r => console.log(`    - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}, Date: ${r.payment_date_formatted}`));
        
        if (driverReceipts.length === 0) {
          console.log(`  ⚠️ No receipts found for driver ${driver.name} (ID: ${driver.id})`);
        }
      } catch (error) {
        console.log(`  ❌ Error testing driver ${driver.name}:`, error.message);
      }
    }

    // Create a test receipt for the first driver if none exist
    if (drivers.length > 0) {
      const testDriver = drivers[0];
      console.log(`\n🧪 Creating test receipt for driver: ${testDriver.name} (ID: ${testDriver.id})`);
      
      try {
        const [result] = await connection.execute(`
          INSERT INTO receipts (
            bill_no, payment_date, payment_amount, payment_mode, 
            reference_number, notes, company_id, customer_id, 
            driver_id, bank_id, bunk_id
          ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        `, [
          'TEST-RECEIPT-' + Date.now(),
          '2024-01-15',
          1500.00,
          'Cash',
          '',
          'Test receipt for driver',
          null,
          null,
          testDriver.id,
          null,
          null
        ]);
        
        console.log(`✅ Test receipt created with ID: ${result.insertId}`);
        
        // Test the query again
        const [testReceipts] = await connection.execute(`
          SELECT DISTINCT
            r.id,
            r.company_id,
            r.driver_id,
            r.bill_no,
            DATE_FORMAT(r.payment_date, '%Y-%m-%d') as payment_date_formatted,
            r.payment_amount,
            r.payment_mode,
            r.reference_number,
            r.notes,
            r.bank_id,
            r.created_at,
            c.name as company_name,
            b.bank_name,
            b.account_number,
            b.ifsc_code,
            b.branch,
            b.account_name as bank_account_name,
            'receipt' as transaction_type
          FROM receipts r
          LEFT JOIN companies c ON r.company_id = c.id
          LEFT JOIN banks b ON r.bank_id = b.id
          WHERE r.driver_id = ?
          ORDER BY r.payment_date DESC, r.created_at DESC
        `, [testDriver.id]);
        
        console.log(`📊 Test receipts found: ${testReceipts.length}`);
        testReceipts.forEach(r => console.log(`  - Receipt ${r.id}: ${r.bill_no}, Amount: ₹${r.payment_amount}`));
        
      } catch (error) {
        console.log(`❌ Error creating test receipt:`, error.message);
      }
    }

  } catch (error) {
    console.error('❌ Error testing receipts API:', error);
  } finally {
    if (connection) {
      await connection.end();
      console.log('\nDatabase connection closed');
    }
  }
}

testReceiptsAPI();



















