const http = require('http');

async function testServerConnection() {
  console.log('🔍 Testing backend server connection...\n');

  const testEndpoints = [
    '/api/health',
    '/api/vehicles',
    '/api/customers', 
    '/api/drivers',
    '/api/invoices',
    '/api/payment-entry',
    '/api/diesel-purchase',
    '/api/receipts',
    '/api/companies',
    '/api/bunks',
    '/api/banks'
  ];

  for (const endpoint of testEndpoints) {
    try {
      const response = await fetch(`http://localhost:5000${endpoint}`);
      const status = response.status;
      const statusText = response.statusText;
      
      if (status === 200) {
        console.log(`✅ ${endpoint}: ${status} ${statusText}`);
      } else {
        console.log(`⚠️  ${endpoint}: ${status} ${statusText}`);
      }
    } catch (error) {
      console.log(`❌ ${endpoint}: Connection failed - ${error.message}`);
    }
  }

  console.log('\n💡 If you see connection failed errors, the backend server is not running.');
  console.log('   Start the server with: cd cement/backend && npm start');
}

testServerConnection();

async function testServerConnection() {
  console.log('🔍 Testing backend server connection...\n');

  const testEndpoints = [
    '/api/health',
    '/api/vehicles',
    '/api/customers', 
    '/api/drivers',
    '/api/invoices',
    '/api/payment-entry',
    '/api/diesel-purchase',
    '/api/receipts',
    '/api/companies',
    '/api/bunks',
    '/api/banks'
  ];

  for (const endpoint of testEndpoints) {
    try {
      const response = await fetch(`http://localhost:5000${endpoint}`);
      const status = response.status;
      const statusText = response.statusText;
      
      if (status === 200) {
        console.log(`✅ ${endpoint}: ${status} ${statusText}`);
      } else {
        console.log(`⚠️  ${endpoint}: ${status} ${statusText}`);
      }
    } catch (error) {
      console.log(`❌ ${endpoint}: Connection failed - ${error.message}`);
    }
  }

  console.log('\n💡 If you see connection failed errors, the backend server is not running.');
  console.log('   Start the server with: cd cement/backend && npm start');
}

testServerConnection();


























