-- ====================================================
-- COMPLETE FIX FOR COMPANY_ID ISSUES
-- Run this entire file in phpMyAdmin
-- ====================================================

-- Step 1: Fix the foreign key to point to company_details table
-- This allows invoices to reference company_details instead of companies
ALTER TABLE invoices
DROP FOREIGN KEY invoices_company_fk;

ALTER TABLE invoices
ADD CONSTRAINT invoices_company_fk
FOREIGN KEY (company_id) REFERENCES company_details(id)
ON DELETE SET NULL;

-- Step 2: Fix existing invoice #500 (set company_id to 20)
UPDATE invoices 
SET company_id = 20 
WHERE supplier_invoice_number = '500';

-- Step 3: Verification - Check if the fix worked
-- This should show invoice #500 with company_id = 20 and company_name populated
SELECT 
  i.id,
  i.supplier_invoice_number,
  i.company_id,
  cd.company_name,
  i.customer_id,
  i.vehicle_id,
  i.created_at
FROM invoices i
LEFT JOIN company_details cd ON i.company_id = cd.id
WHERE i.supplier_invoice_number = '500';

-- ====================================================
-- After running this file:
-- 1. Backend is already updated (restart if needed)
-- 2. Frontend is already updated (restart if needed)
-- 3. Refresh browser with Ctrl+Shift+R
-- 4. Invoice #500 should now show with correct company name
-- 5. All new invoices will work correctly
-- ====================================================

