const mysql = require('mysql2/promise');
require('dotenv').config();

async function createSettingsCompaniesTable() {
  let connection;
  try {
    connection = await mysql.createConnection({
      host: process.env.DB_HOST || 'localhost',
      user: process.env.DB_USER || 'root',
      password: process.env.DB_PASSWORD || '',
      database: process.env.DB_NAME || 'cement'
    });

    console.log('\n========================================');
    console.log('CREATING SETTINGS COMPANIES TABLE');
    console.log('========================================\n');

    // Create settings_companies table
    const createTableSQL = `
      CREATE TABLE IF NOT EXISTS settings_companies (
        id INT PRIMARY KEY AUTO_INCREMENT,
        company_name VARCHAR(255) NOT NULL,
        gst VARCHAR(100),
        phone VARCHAR(20),
        address TEXT,
        city VARCHAR(100),
        email VARCHAR(100),
        pan VARCHAR(50),
        bank_name VARCHAR(255),
        account_number VARCHAR(100),
        ifsc VARCHAR(50),
        branch VARCHAR(255),
        account_name VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
    `;

    console.log('Creating settings_companies table...');
    await connection.execute(createTableSQL);
    console.log('✅ Table created successfully!\n');

    // Check if table has data
    const [count] = await connection.execute('SELECT COUNT(*) as count FROM settings_companies');
    console.log(`Current records in settings_companies: ${count[0].count}`);

    if (count[0].count === 0) {
      console.log('\n📋 Migrating existing data from company_details...');
      await connection.execute(`
        INSERT INTO settings_companies 
        (company_name, gst, phone, address, city, email, pan, bank_name, account_number, ifsc, branch, account_name)
        SELECT company_name, gst, phone, address, city, email, pan, bank_name, account_number, ifsc, branch, account_name
        FROM company_details
        WHERE company_name IS NOT NULL
      `);
      
      const [newCount] = await connection.execute('SELECT COUNT(*) as count FROM settings_companies');
      console.log(`✅ Migrated ${newCount[0].count} companies to settings_companies table\n`);
    }

    console.log('========================================');
    console.log('✅ DONE! Settings companies table ready');
    console.log('========================================\n');

  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    if (connection) {
      await connection.end();
    }
  }
}

createSettingsCompaniesTable();














