-- Fix foreign key constraint for invoices table
-- This changes the company_id reference from 'companies' table to 'company_details' table

-- Step 1: Drop the old foreign key constraint
ALTER TABLE invoices
DROP FOREIGN KEY invoices_company_fk;

-- Step 2: Add new foreign key constraint pointing to company_details
ALTER TABLE invoices
ADD CONSTRAINT invoices_company_fk
FOREIGN KEY (company_id) REFERENCES company_details(id)
ON DELETE SET NULL;

-- Verification query (optional - run after the above)
-- SELECT 
--   CONSTRAINT_NAME, 
--   TABLE_NAME, 
--   COLUMN_NAME, 
--   REFERENCED_TABLE_NAME, 
--   REFERENCED_COLUMN_NAME
-- FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
-- WHERE TABLE_NAME = 'invoices' AND CONSTRAINT_NAME = 'invoices_company_fk';

