-- ====================================================
-- SIMPLE FIX FOR COMPANY_ID ISSUE
-- Copy ALL commands below and paste in phpMyAdmin SQL tab
-- ====================================================

-- Drop any existing foreign key (try all possible names, ignore errors)
ALTER TABLE invoices DROP FOREIGN KEY invoices_company_fk;
ALTER TABLE invoices DROP FOREIGN KEY invoices_ibfk_1;
ALTER TABLE invoices DROP FOREIGN KEY invoices_ibfk_2;
ALTER TABLE invoices DROP FOREIGN KEY fk_company_id;

-- Add the CORRECT foreign key to company_details table
ALTER TABLE invoices 
ADD CONSTRAINT invoices_company_fk 
FOREIGN KEY (company_id) 
REFERENCES company_details(id) 
ON DELETE SET NULL;

-- Fix existing invoice #500
UPDATE invoices 
SET company_id = 20 
WHERE supplier_invoice_number = '500';

-- ====================================================
-- IMPORTANT: Some ALTER TABLE commands above may show errors
-- like "Can't DROP FOREIGN KEY" - THIS IS NORMAL!
-- It just means that foreign key name doesn't exist.
-- 
-- The IMPORTANT command is the ADD CONSTRAINT.
-- If it says "Duplicate key name" that means it already exists
-- and you can skip to the UPDATE command.
-- ====================================================


