-- ====================================================
-- FINAL FIX FOR COMPANY_ID FOREIGN KEY
-- This will fix the issue of company_id being NULL
-- ====================================================

-- Step 1: Find all foreign keys on invoices table
-- Run this first to see what exists:
-- SELECT CONSTRAINT_NAME 
-- FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
-- WHERE TABLE_NAME = 'invoices' AND COLUMN_NAME = 'company_id' AND CONSTRAINT_NAME != 'PRIMARY';

-- Step 2: Drop ALL possible foreign key names (ignore errors if they don't exist)
-- Try common names:
SET @drop_fk1 = 'ALTER TABLE invoices DROP FOREIGN KEY invoices_company_fk';
SET @drop_fk2 = 'ALTER TABLE invoices DROP FOREIGN KEY invoices_ibfk_1';
SET @drop_fk3 = 'ALTER TABLE invoices DROP FOREIGN KEY invoices_ibfk_2';
SET @drop_fk4 = 'ALTER TABLE invoices DROP FOREIGN KEY fk_invoices_company';

-- Execute drops (ignore errors)
SET @sql = IF((SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
    WHERE CONSTRAINT_SCHEMA = 'cement' AND TABLE_NAME = 'invoices' 
    AND CONSTRAINT_NAME = 'invoices_company_fk') > 0, 
    'ALTER TABLE invoices DROP FOREIGN KEY invoices_company_fk', 
    'SELECT 1');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Step 3: Add the CORRECT foreign key pointing to company_details
ALTER TABLE invoices 
ADD CONSTRAINT invoices_company_fk 
FOREIGN KEY (company_id) REFERENCES company_details(id) 
ON DELETE SET NULL;

-- Step 4: Fix existing invoice #500
UPDATE invoices 
SET company_id = 20 
WHERE supplier_invoice_number = '500';

-- Step 5: Verify the fix
SELECT 
  i.id,
  i.supplier_invoice_number,
  i.company_id,
  cd.company_name as company_name_from_company_details,
  i.customer_id,
  i.vehicle_id
FROM invoices i
LEFT JOIN company_details cd ON i.company_id = cd.id
WHERE i.supplier_invoice_number = '500';

-- ====================================================
-- After running this:
-- 1. New invoices will save company_id correctly
-- 2. Invoice #500 will show correct company name
-- 3. Restart backend and frontend
-- 4. Clear browser cache (Ctrl+Shift+R)
-- ====================================================


