const mysql = require('mysql2/promise');
require('dotenv').config();

async function setupCashTable() {
  let connection;
  
  try {
    // Create connection
    connection = await mysql.createConnection({
      host: process.env.DB_HOST || 'localhost',
      user: process.env.DB_USER || 'root',
      password: process.env.DB_PASSWORD || '',
      database: process.env.DB_NAME || 'cement',
    });

    console.log('Connected to database');

    // Create cash_transactions table
    const createTableQuery = `
      CREATE TABLE IF NOT EXISTS cash_transactions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        bill_no VARCHAR(100) NOT NULL UNIQUE,
        transaction_date DATE NOT NULL,
        amount DECIMAL(10, 2) NOT NULL,
        bank_id INT NULL,
        mode ENUM('cash', 'bank', 'upi', 'cheque') NOT NULL DEFAULT 'cash',
        description TEXT NULL,
        reference_number VARCHAR(255) NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (bank_id) REFERENCES banks(id) ON DELETE SET NULL,
        INDEX idx_bill_no (bill_no),
        INDEX idx_transaction_date (transaction_date),
        INDEX idx_mode (mode),
        INDEX idx_bank_id (bank_id)
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    `;

    await connection.execute(createTableQuery);
    console.log('✓ cash_transactions table created successfully');

    // Check if table has data
    const [rows] = await connection.execute('SELECT COUNT(*) as count FROM cash_transactions');
    console.log(`✓ Current records in cash_transactions table: ${rows[0].count}`);

    console.log('\n✓ Database setup completed successfully!');
    
  } catch (error) {
    console.error('Error setting up database:', error);
    process.exit(1);
  } finally {
    if (connection) {
      await connection.end();
      console.log('Database connection closed');
    }
  }
}

// Run the setup
setupCashTable();









